/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.axis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.axis.Messages;
import org.eclipse.swtchart.internal.series.SeriesSet;

public class AxisSet
implements IAxisSet {
    private HashMap<Integer, Axis> xAxisMap;
    private HashMap<Integer, Axis> yAxisMap;
    private Chart chart;

    public AxisSet(Chart chart) {
        this.chart = chart;
        this.xAxisMap = new HashMap();
        this.yAxisMap = new HashMap();
        Axis xAxis = new Axis(0, IAxis.Direction.X, chart);
        Axis yAxis = new Axis(0, IAxis.Direction.Y, chart);
        this.xAxisMap.put(0, xAxis);
        this.yAxisMap.put(0, yAxis);
    }

    private HashMap<Integer, Axis> getAxisMap(IAxis.Direction direction) {
        if (direction == IAxis.Direction.X) {
            return this.xAxisMap;
        }
        return this.yAxisMap;
    }

    @Override
    public int createXAxis() {
        return this.createAxis(IAxis.Direction.X);
    }

    @Override
    public int createYAxis() {
        return this.createAxis(IAxis.Direction.Y);
    }

    private int createAxis(IAxis.Direction direction) {
        int id = this.getUniqueId(direction);
        Axis axis = new Axis(id, direction, this.chart);
        this.getAxisMap(direction).put(id, axis);
        this.chart.updateLayout();
        SeriesSet series = (SeriesSet)this.chart.getSeriesSet();
        if (series != null) {
            series.compressAllSeries();
        }
        return id;
    }

    private int getUniqueId(IAxis.Direction direction) {
        Set<Integer> keySet = this.getAxisMap(direction).keySet();
        int i = 0;
        while (keySet.contains(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public IAxis getXAxis(int id) {
        return this.getAxis(id, IAxis.Direction.X);
    }

    @Override
    public IAxis getYAxis(int id) {
        return this.getAxis(id, IAxis.Direction.Y);
    }

    private IAxis getAxis(int id, IAxis.Direction direction) {
        return this.getAxisMap(direction).get(id);
    }

    @Override
    public IAxis[] getXAxes() {
        Collection<Axis> values = this.xAxisMap.values();
        return values.toArray(new Axis[values.size()]);
    }

    @Override
    public IAxis[] getYAxes() {
        Collection<Axis> values = this.yAxisMap.values();
        return values.toArray(new Axis[values.size()]);
    }

    @Override
    public IAxis[] getAxes() {
        ArrayList<Axis> axes = new ArrayList<Axis>();
        axes.addAll(this.xAxisMap.values());
        axes.addAll(this.yAxisMap.values());
        return axes.toArray(new Axis[axes.size()]);
    }

    @Override
    public int[] getXAxisIds() {
        return this.getAxisIds(IAxis.Direction.X);
    }

    @Override
    public int[] getYAxisIds() {
        return this.getAxisIds(IAxis.Direction.Y);
    }

    private int[] getAxisIds(IAxis.Direction direction) {
        Set<Integer> keySet = this.getAxisMap(direction).keySet();
        Integer[] array = keySet.toArray(new Integer[keySet.size()]);
        int[] ids = new int[array.length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = array[i];
            ++i;
        }
        Arrays.sort(ids);
        return ids;
    }

    @Override
    public void deleteXAxis(int id) {
        this.deleteAxis(id, IAxis.Direction.X);
    }

    @Override
    public void deleteYAxis(int id) {
        this.deleteAxis(id, IAxis.Direction.Y);
    }

    private void deleteAxis(int id, IAxis.Direction direction) {
        if (id == 0) {
            SWT.error((int)7);
        }
        if (this.getAxisMap(direction).get(id) == null) {
            throw new IllegalArgumentException(Messages.getString("AXIS_ID_DONT_EXIST"));
        }
        ((Axis)this.getAxis(id, direction)).dispose();
        this.getAxisMap(direction).remove(id);
        ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            if (direction == IAxis.Direction.X) {
                if (series.getXAxisId() == id) {
                    series.setXAxisId(0);
                }
            } else if (series.getYAxisId() == id) {
                series.setYAxisId(0);
            }
            ++n2;
        }
        this.chart.updateLayout();
    }

    @Override
    public void adjustRange() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ((Axis)axis).adjustRange(false);
            ++n2;
        }
        this.chart.updateLayout();
    }

    @Override
    public void zoomIn() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.zoomIn();
            ++n2;
        }
    }

    @Override
    public void zoomOut() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.zoomOut();
            ++n2;
        }
    }

    public void updateLayoutData() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ((Axis)axis).updateLayoutData();
            ++n2;
        }
    }

    public void refresh() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ((Axis)axis).refresh();
            ++n2;
        }
    }

    public void dispose() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ((Axis)axis).dispose();
            ++n2;
        }
    }
}

