/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiComparators;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiIRQ;

public class LamiIRQNumberAspect
extends LamiGenericAspect {
    public LamiIRQNumberAspect(String colName, int colIndex) {
        super(String.valueOf(colName) + " (#)", null, colIndex, false, false);
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        Number number = this.resolveNumber(entry);
        if (number == null) {
            return entry.getValue(this.getColIndex()).toString();
        }
        return String.valueOf(number);
    }

    @Override
    public @Nullable Number resolveNumber(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.getColIndex());
        if (data instanceof LamiIRQ) {
            return ((LamiIRQ)data).getNumber();
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return LamiComparators.getLongComparator(this::resolveNumber);
    }
}

