/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.dataprovider;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@NonNullByDefault
public class DataProviderParameterTest {
    private static final String CUSTOM_KEY = "MyKey";
    private static Map<String, Object> fParameters = new HashMap<String, Object>();
    private List<?> fLongList = Arrays.asList(1L, 2L, 3L);
    private List<?> fIntList = Arrays.asList(1, 2, 3);
    private List<?> fMixedList = Arrays.asList(1, 2L, 3);
    private String fWrongParameter = "Unsupported";

    @BeforeClass
    public static void setUp() {
        fParameters.put("requested_times", Collections.emptyList());
        fParameters.put("requested_items", Collections.emptyList());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testExtractTimeRequested() {
        fParameters.put("requested_times", this.fLongList);
        @NonNull List timeRequested = DataProviderParameterUtils.extractTimeRequested(fParameters);
        Assert.assertNotNull((Object)timeRequested);
        DataProviderParameterTest.testLongList(timeRequested);
        fParameters.put("requested_times", this.fIntList);
        timeRequested = DataProviderParameterUtils.extractTimeRequested(fParameters);
        Assert.assertNotNull((Object)timeRequested);
        DataProviderParameterTest.testLongList(timeRequested);
        fParameters.put("requested_times", this.fMixedList);
        timeRequested = DataProviderParameterUtils.extractTimeRequested(fParameters);
        Assert.assertNotNull((Object)timeRequested);
        DataProviderParameterTest.testLongList(timeRequested);
        fParameters.put("requested_times", this.fWrongParameter);
        timeRequested = DataProviderParameterUtils.extractTimeRequested(fParameters);
        Assert.assertNull((Object)timeRequested);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testExtractSelectedItems() {
        fParameters.put("requested_items", this.fLongList);
        @NonNull List items = DataProviderParameterUtils.extractSelectedItems(fParameters);
        Assert.assertNotNull((Object)items);
        DataProviderParameterTest.testLongList(items);
        fParameters.put("requested_items", this.fIntList);
        items = DataProviderParameterUtils.extractSelectedItems(fParameters);
        Assert.assertNotNull((Object)items);
        DataProviderParameterTest.testLongList(items);
        fParameters.put("requested_items", this.fMixedList);
        items = DataProviderParameterUtils.extractSelectedItems(fParameters);
        Assert.assertNotNull((Object)items);
        DataProviderParameterTest.testLongList(items);
        fParameters.put("requested_items", this.fWrongParameter);
        items = DataProviderParameterUtils.extractSelectedItems(fParameters);
        Assert.assertNull((Object)items);
    }

    @Test
    public void testExtractLongList() {
        fParameters.put(CUSTOM_KEY, this.fLongList);
        List longList = DataProviderParameterUtils.extractLongList(fParameters, (String)CUSTOM_KEY);
        Assert.assertNotNull((Object)longList);
        DataProviderParameterTest.testLongList(longList);
    }

    @Test
    public void testExtractBoolean() {
        fParameters.put(CUSTOM_KEY, Boolean.TRUE);
        Boolean extractedBoolean = DataProviderParameterUtils.extractBoolean(fParameters, (String)CUSTOM_KEY);
        Assert.assertNotNull((Object)extractedBoolean);
        Assert.assertTrue((boolean)extractedBoolean);
        fParameters.put(CUSTOM_KEY, Boolean.FALSE);
        extractedBoolean = DataProviderParameterUtils.extractBoolean(fParameters, (String)CUSTOM_KEY);
        Assert.assertNotNull((Object)extractedBoolean);
        Assert.assertFalse((boolean)extractedBoolean);
    }

    private static void testLongList(List<?> listToTest) {
        Assert.assertEquals((long)3L, (long)listToTest.size());
        Assert.assertTrue((boolean)listToTest.stream().allMatch(e -> e instanceof Long));
    }
}

