/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBaseDeclSpecifier;

public class CASTSimpleDeclSpecifier
extends CASTBaseDeclSpecifier
implements ICASTSimpleDeclSpecifier {
    private int simpleType;
    private boolean isSigned;
    private boolean isUnsigned;
    private boolean isShort;
    private boolean isLong;
    private boolean longlong;
    private boolean complex;
    private boolean imaginary;
    private IASTExpression fDeclTypeExpression;

    @Override
    public CASTSimpleDeclSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTSimpleDeclSpecifier copy(IASTNode.CopyStyle style) {
        CASTSimpleDeclSpecifier copy = new CASTSimpleDeclSpecifier();
        return this.copy(copy, style);
    }

    @Override
    protected <T extends CASTSimpleDeclSpecifier> T copy(T copy, IASTNode.CopyStyle style) {
        T target = copy;
        target.simpleType = this.simpleType;
        target.isSigned = this.isSigned;
        target.isUnsigned = this.isUnsigned;
        target.isShort = this.isShort;
        target.isLong = this.isLong;
        target.longlong = this.longlong;
        target.complex = this.complex;
        target.imaginary = this.imaginary;
        if (this.fDeclTypeExpression != null) {
            copy.setDeclTypeExpression(this.fDeclTypeExpression.copy(style));
        }
        return super.copy(copy, style);
    }

    @Override
    public int getType() {
        return this.simpleType;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    @Override
    public boolean isShort() {
        return this.isShort;
    }

    @Override
    public boolean isLong() {
        return this.isLong;
    }

    @Override
    public void setType(int type) {
        this.assertNotFrozen();
        this.simpleType = type;
    }

    @Override
    public void setType(IBasicType.Kind kind) {
        this.setType(this.getType(kind));
    }

    private int getType(IBasicType.Kind kind) {
        switch (kind) {
            case eBoolean: {
                return 6;
            }
            case eChar: 
            case eWChar: 
            case eChar16: 
            case eChar32: {
                return 2;
            }
            case eDouble: {
                return 5;
            }
            case eFloat: {
                return 4;
            }
            case eFloat128: {
                return 4;
            }
            case eDecimal32: {
                return 15;
            }
            case eDecimal64: {
                return 16;
            }
            case eDecimal128: {
                return 17;
            }
            case eInt: {
                return 3;
            }
            case eInt128: {
                return 13;
            }
            case eUnspecified: {
                return 0;
            }
            case eVoid: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void setShort(boolean value) {
        this.assertNotFrozen();
        this.isShort = value;
    }

    @Override
    public void setLong(boolean value) {
        this.assertNotFrozen();
        this.isLong = value;
    }

    @Override
    public void setUnsigned(boolean value) {
        this.assertNotFrozen();
        this.isUnsigned = value;
    }

    @Override
    public void setSigned(boolean value) {
        this.assertNotFrozen();
        this.isSigned = value;
    }

    @Override
    public boolean isLongLong() {
        return this.longlong;
    }

    @Override
    public void setLongLong(boolean value) {
        this.assertNotFrozen();
        this.longlong = value;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.visitAlignmentSpecifiers(action)) {
            return false;
        }
        if (this.fDeclTypeExpression != null && !this.fDeclTypeExpression.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isComplex() {
        return this.complex;
    }

    @Override
    public void setComplex(boolean value) {
        this.assertNotFrozen();
        this.complex = value;
    }

    @Override
    public boolean isImaginary() {
        return this.imaginary;
    }

    @Override
    public void setImaginary(boolean value) {
        this.assertNotFrozen();
        this.imaginary = value;
    }

    @Override
    public IASTExpression getDeclTypeExpression() {
        return this.fDeclTypeExpression;
    }

    @Override
    public void setDeclTypeExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fDeclTypeExpression = expression;
        if (expression != null) {
            expression.setPropertyInParent(DECLTYPE_EXPRESSION);
            expression.setParent(this);
        }
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fDeclTypeExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fDeclTypeExpression = (IASTExpression)other;
            return;
        }
        super.replace(child, other);
    }
}

