/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore;

import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.tests.stubs.segmentstore.StubSegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreDensityDataProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreDensityDataProviderFactory;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.model.SeriesModel;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SegmentStoreDensityDataProviderTest {
    private static ITmfTreeXYDataProvider<@NonNull TmfTreeDataModel> fDataProvider;
    private static ITmfTreeXYDataProvider<@NonNull TmfTreeDataModel> fDataProviderNullSegments;
    private static final @NonNull TmfXmlTraceStub fTrace;
    private static final double[] yValues;
    private static final long[] xValues;
    private static final long[] xValuesNull;
    private static final double[] yValuesNull;
    private static final String ID = "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore";

    static {
        fTrace = new TmfXmlTraceStubNs();
        yValues = new double[]{15.0, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, 15.0, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, 15.0, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, 15.0, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, 15.0, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, 15.0, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, 15.0, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE};
        long[] lArray = new long[100];
        lArray[17] = 1L;
        lArray[18] = 1L;
        lArray[19] = 1L;
        lArray[20] = 1L;
        lArray[21] = 1L;
        lArray[22] = 1L;
        lArray[23] = 1L;
        lArray[24] = 1L;
        lArray[25] = 1L;
        lArray[26] = 1L;
        lArray[27] = 1L;
        lArray[28] = 1L;
        lArray[29] = 1L;
        lArray[30] = 1L;
        lArray[31] = 1L;
        lArray[32] = 1L;
        lArray[33] = 1L;
        lArray[34] = 2L;
        lArray[35] = 2L;
        lArray[36] = 2L;
        lArray[37] = 2L;
        lArray[38] = 2L;
        lArray[39] = 2L;
        lArray[40] = 2L;
        lArray[41] = 2L;
        lArray[42] = 2L;
        lArray[43] = 2L;
        lArray[44] = 2L;
        lArray[45] = 2L;
        lArray[46] = 2L;
        lArray[47] = 2L;
        lArray[48] = 2L;
        lArray[49] = 2L;
        lArray[50] = 3L;
        lArray[51] = 3L;
        lArray[52] = 3L;
        lArray[53] = 3L;
        lArray[54] = 3L;
        lArray[55] = 3L;
        lArray[56] = 3L;
        lArray[57] = 3L;
        lArray[58] = 3L;
        lArray[59] = 3L;
        lArray[60] = 3L;
        lArray[61] = 3L;
        lArray[62] = 3L;
        lArray[63] = 3L;
        lArray[64] = 3L;
        lArray[65] = 3L;
        lArray[66] = 3L;
        lArray[67] = 4L;
        lArray[68] = 4L;
        lArray[69] = 4L;
        lArray[70] = 4L;
        lArray[71] = 4L;
        lArray[72] = 4L;
        lArray[73] = 4L;
        lArray[74] = 4L;
        lArray[75] = 4L;
        lArray[76] = 4L;
        lArray[77] = 4L;
        lArray[78] = 4L;
        lArray[79] = 4L;
        lArray[80] = 4L;
        lArray[81] = 4L;
        lArray[82] = 4L;
        lArray[83] = 4L;
        lArray[84] = 5L;
        lArray[85] = 5L;
        lArray[86] = 5L;
        lArray[87] = 5L;
        lArray[88] = 5L;
        lArray[89] = 5L;
        lArray[90] = 5L;
        lArray[91] = 5L;
        lArray[92] = 5L;
        lArray[93] = 5L;
        lArray[94] = 5L;
        lArray[95] = 5L;
        lArray[96] = 5L;
        lArray[97] = 5L;
        lArray[98] = 5L;
        lArray[99] = 5L;
        xValues = lArray;
        xValuesNull = new long[100];
        yValuesNull = new double[]{Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE};
    }

    @BeforeClass
    public static void init() throws TmfAnalysisException {
        StubSegmentStoreProvider fixture = SegmentStoreDensityDataProviderTest.getValidSegment((ITmfTrace)fTrace);
        SegmentStoreDensityDataProviderFactory fp = new SegmentStoreDensityDataProviderFactory();
        Assert.assertNull((Object)fp.createProvider((ITmfTrace)fTrace));
        Assert.assertNotNull((Object)fp.createProvider((ITmfTrace)fTrace, ID));
        Assert.assertTrue((boolean)fp.getDescriptors((ITmfTrace)fTrace).isEmpty());
        fDataProvider = new SegmentStoreDensityDataProvider((ITmfTrace)fTrace, (ISegmentStoreProvider)fixture, ID);
        StubSegmentStoreProvider fixtureNull = SegmentStoreDensityDataProviderTest.getValidNullSegment((ITmfTrace)fTrace);
        SegmentStoreDensityDataProviderFactory fpNullSegment = new SegmentStoreDensityDataProviderFactory();
        Assert.assertNull((Object)fpNullSegment.createProvider((ITmfTrace)fTrace));
        Assert.assertNotNull((Object)fpNullSegment.createProvider((ITmfTrace)fTrace, ID));
        Assert.assertTrue((boolean)fpNullSegment.getDescriptors((ITmfTrace)fTrace).isEmpty());
        fDataProviderNullSegments = new SegmentStoreDensityDataProvider((ITmfTrace)fTrace, (ISegmentStoreProvider)fixtureNull, ID);
    }

    @AfterClass
    public static void clean() {
        fTrace.dispose();
    }

    private static @NonNull StubSegmentStoreProvider getValidSegment(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        StubSegmentStoreProvider fixture = new StubSegmentStoreProvider(false);
        fixture.setTrace(trace);
        fixture.schedule();
        fixture.waitForCompletion();
        return fixture;
    }

    private static @NonNull StubSegmentStoreProvider getValidNullSegment(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        StubSegmentStoreProvider fixture = new StubSegmentStoreProvider(true);
        fixture.setTrace(trace);
        fixture.schedule();
        fixture.waitForCompletion();
        return fixture;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchXY() {
        TimeQueryFilter timeQueryFilter = new TimeQueryFilter(0L, 100L, 100);
        @NonNull TmfModelResponse response = fDataProvider.fetchXY(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)timeQueryFilter), null);
        Assert.assertNotNull((Object)response);
        ITmfXyModel responseModel = (ITmfXyModel)response.getModel();
        Assert.assertNotNull((Object)responseModel);
        SeriesModel seriesResponse = (SeriesModel)responseModel.getSeriesData().toArray()[0];
        Assert.assertTrue((boolean)Arrays.equals(yValues, seriesResponse.getData()));
        Assert.assertTrue((boolean)Arrays.equals(xValues, seriesResponse.getXAxis()));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderNullFetchXY() {
        TimeQueryFilter timeQueryFilter = new TimeQueryFilter(0L, 100L, 100);
        @NonNull TmfModelResponse response = fDataProviderNullSegments.fetchXY(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)timeQueryFilter), null);
        Assert.assertNotNull((Object)response);
        ITmfXyModel responseModel = (ITmfXyModel)response.getModel();
        Assert.assertNotNull((Object)responseModel);
        SeriesModel seriesResponse = (SeriesModel)responseModel.getSeriesData().toArray()[0];
        Assert.assertTrue((boolean)Arrays.equals(yValuesNull, seriesResponse.getData()));
        Assert.assertTrue((boolean)Arrays.equals(xValuesNull, seriesResponse.getXAxis()));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTree() {
        TimeQueryFilter timeQueryFilter = new TimeQueryFilter(0L, 100L, 100);
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)timeQueryFilter), null);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testID() {
        Assert.assertTrue((boolean)fDataProvider.getId().equals(ID));
    }
}

