/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessControlService;
import org.eclipse.remote.internal.core.RemoteConnectionType;

public class RemoteProcess
extends Process
implements IRemoteProcess {
    private final Map<Class<? extends IRemoteProcess.Service>, IRemoteProcess.Service> servicesMap = new HashMap<Class<? extends IRemoteProcess.Service>, IRemoteProcess.Service>();
    private final IRemoteConnection connection;
    private final IRemoteProcessBuilder builder;

    public RemoteProcess(IRemoteConnection connection, IRemoteProcessBuilder builder) {
        this.connection = connection;
        this.builder = builder;
    }

    @Override
    public void destroy() {
        IRemoteProcessControlService controlService = this.getService(IRemoteProcessControlService.class);
        if (controlService != null) {
            controlService.destroy();
        }
    }

    @Override
    public int exitValue() {
        IRemoteProcessControlService controlService = this.getService(IRemoteProcessControlService.class);
        if (controlService != null) {
            return controlService.exitValue();
        }
        return 0;
    }

    @Override
    public InputStream getErrorStream() {
        IRemoteProcessControlService controlService = this.getService(IRemoteProcessControlService.class);
        if (controlService != null) {
            return controlService.getErrorStream();
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        IRemoteProcessControlService controlService = this.getService(IRemoteProcessControlService.class);
        if (controlService != null) {
            return controlService.getInputStream();
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() {
        IRemoteProcessControlService controlService = this.getService(IRemoteProcessControlService.class);
        if (controlService != null) {
            return controlService.getOutputStream();
        }
        return null;
    }

    @Override
    public <T extends IRemoteProcess.Service> T getService(Class<T> service) {
        IRemoteProcess.Service obj = this.servicesMap.get(service);
        if (obj == null && (obj = this.getConnectionType().getProcessService(this, service)) != null) {
            this.servicesMap.put(service, obj);
        }
        return (T)obj;
    }

    @Override
    public <T extends IRemoteProcess.Service> boolean hasService(Class<T> service) {
        return this.servicesMap.get(service.getName()) != null || this.getConnectionType().hasProcessService(service);
    }

    @Override
    public int waitFor() throws InterruptedException {
        IRemoteProcessControlService controlService = this.getService(IRemoteProcessControlService.class);
        if (controlService != null) {
            return controlService.waitFor();
        }
        return 0;
    }

    @Override
    public boolean isCompleted() {
        IRemoteProcessControlService controlService = this.getService(IRemoteProcessControlService.class);
        if (controlService != null) {
            return controlService.isCompleted();
        }
        return true;
    }

    @Override
    public IRemoteConnection getRemoteConnection() {
        return this.connection;
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder() {
        return this.builder;
    }

    private RemoteConnectionType getConnectionType() {
        return (RemoteConnectionType)this.getRemoteConnection().getConnectionType();
    }
}

