/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis.ondemand;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysis;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.OnDemandAnalysisManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.ondemand.OnDemandAnalysisStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub2;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub3;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OnDemandAnalysisTest {
    private IOnDemandAnalysis analysis = new OnDemandAnalysisStub();
    private ITmfTrace fTraceThatApplies;
    private ITmfTrace fTraceThatDoesntApply;

    @Before
    public void setup() {
        this.fTraceThatApplies = new TmfTraceStub2();
        this.fTraceThatDoesntApply = new TmfTraceStub3();
    }

    @After
    public void teardown() {
        if (this.fTraceThatApplies != null) {
            this.fTraceThatApplies.dispose();
            this.fTraceThatApplies = null;
        }
        if (this.fTraceThatDoesntApply != null) {
            this.fTraceThatDoesntApply.dispose();
            this.fTraceThatDoesntApply = null;
        }
    }

    @Test
    public void testApplies() {
        ITmfTrace trace = this.fTraceThatApplies;
        Assert.assertNotNull((Object)trace);
        Assert.assertTrue((boolean)this.analysis.appliesTo(trace));
    }

    @Test
    public void testDoesNotApply() {
        ITmfTrace trace = this.fTraceThatDoesntApply;
        Assert.assertNotNull((Object)trace);
        Assert.assertFalse((boolean)this.analysis.appliesTo(trace));
    }

    @Test
    public void testGetAnalysisFromTrace() {
        ITmfTrace trace = this.fTraceThatApplies;
        Assert.assertNotNull((Object)trace);
        Set set1 = OnDemandAnalysisManager.getInstance().getOndemandAnalyses(trace);
        Assert.assertEquals((long)1L, (long)set1.size());
        Assert.assertTrue((boolean)(Iterables.getOnlyElement((Iterable)set1) instanceof OnDemandAnalysisStub));
        Set set2 = OnDemandAnalysisManager.getInstance().getOndemandAnalyses(trace);
        Assert.assertTrue((boolean)set1.equals(set2));
    }

    @Test
    public void testGetNoAnalysisFromTrace() {
        ITmfTrace trace = this.fTraceThatDoesntApply;
        Assert.assertNotNull((Object)trace);
        Set set = OnDemandAnalysisManager.getInstance().getOndemandAnalyses(trace);
        Assert.assertTrue((boolean)set.isEmpty());
    }
}

