/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TestXmlUtils {
    private static final String BILLION_LAUGH_ATTACK = "<?xml version=\"1.0\"?>\n<!DOCTYPE lolz [\n<!ENTITY lol \"lol\">\n<!ENTITY lol2 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n<!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\n<!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\n<!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\n<!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\n<!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\n<!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\n<!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\n]>\n<lolz>&lol9;</lolz>";
    private static final String RECURSIVE_ENTITY_REFERENCE = "<!DOCTYPE A [\n <!ELEMENT A ANY>\n <!ENTITY A \"<A>&B;</A>\"> \n <!ENTITY B \"&A;\">\n]>\n<A>&A;</A>";
    private static final String XML_INJECTION_ATTACK = "<?xml version=\"1.0\"?>\n<!DOCTYPE order [\n<!ELEMENT foo ANY >\n<!ENTITY xxe SYSTEM \"file:///dev/random\" >\n]>\n<soap:Envelope xmlns:soap=\"http://www.w3.org/2001/12/soap-envelope\" soap:encodingStyle=\"http://www.w3.org/2001/12/soap-encoding\">\n  <soap:Body xmlns:m=\"http://www.example.org/order\">\n     <foo>&xxe;</foo>\n  </soap:Body>\n</soap:Envelope>\n";
    private static final String SCHEMA_XXE_ATTACK = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE foo [ <!ELEMENT foo ANY >\n<!ENTITY xxe SYSTEM \"file:///etc/passwd\" >]>\n<creds>\n    <user>&xxe;</user>\n    <pass>mypass</pass>\n</creds>";
    private static final String GET_PASSWORD_ATTACK = " <?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n <!DOCTYPE foo [   <!ELEMENT foo ANY >   <!ENTITY xxe SYSTEM \"file:///etc/passwd\" >]><foo>&xxe;</foo> <?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n <!DOCTYPE foo [  \n   <!ELEMENT foo ANY >\n   <!ENTITY xxe SYSTEM \"file:///etc/shadow\" >]><foo>&xxe;</foo>\n\n <?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n <!DOCTYPE foo [  \n   <!ELEMENT foo ANY >\n   <!ENTITY xxe SYSTEM \"file:///c:/boot.ini\" >]><foo>&xxe;</foo>\n\n <?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n <!DOCTYPE foo [  \n   <!ELEMENT foo ANY >\n   <!ENTITY xxe SYSTEM \"http://www.attacker.com/text.txt\" >]><foo>&xxe;</foo>";
    private static String SAFE_SCHEMA = "<?xml version=\"1.0\"?>\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" ><xs:element name=\"note\">   <xs:complexType>     <xs:sequence>       <xs:element name=\"to\" type=\"xs:string\"/>       <xs:element name=\"from\" type=\"xs:string\"/>       <xs:element name=\"heading\" type=\"xs:string\"/>       <xs:element name=\"body\" type=\"xs:string\"/>     </xs:sequence>   </xs:complexType> </xs:element> </xs:schema>";
    private static String SAFE_DOCUMENT = "<?xml version=\"1.0\"?><note>  <to>Tove</to>  <from>Jani</from>  <heading>Reminder</heading>  <body>Don't forget me this weekend!</body></note> ";

    private static void testExploit(String attackVector) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        Transformer newSafeTransformer = XmlUtils.newSecureTransformer();
        Assert.assertNotNull((Object)newSafeTransformer);
        DocumentBuilderFactory dbf = XmlUtils.newSafeDocumentBuilderFactory();
        Document document = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(attackVector)));
        newSafeTransformer.setOutputProperty("method", "xml");
        newSafeTransformer.setOutputProperty("indent", "yes");
        newSafeTransformer.setOutputProperty("encoding", "UTF-8");
        StreamResult output = new StreamResult(new StringWriter());
        newSafeTransformer.transform(new DOMSource(document), output);
    }

    @Test(expected=SAXException.class)
    public void testBillionLaughs() throws TransformerException, SAXException, IOException, ParserConfigurationException {
        TestXmlUtils.testExploit(BILLION_LAUGH_ATTACK);
    }

    @Test(expected=SAXException.class)
    public void testRecursiveEntityReference() throws TransformerException, SAXException, IOException, ParserConfigurationException {
        TestXmlUtils.testExploit(RECURSIVE_ENTITY_REFERENCE);
    }

    @Ignore
    @Test(expected=IOException.class)
    public void testXmlInjection() throws SAXException, IOException, ParserConfigurationException, TransformerException {
        TestXmlUtils.testExploit(XML_INJECTION_ATTACK);
    }

    @Test(expected=SAXException.class)
    public void testNewSafeSchemaFactory() throws SAXException {
        SchemaFactory schemaFactory = XmlUtils.newSafeSchemaFactory();
        Assert.assertNotNull((Object)schemaFactory);
        Schema schema = XmlUtils.newSafeSchemaFactory().newSchema(new StreamSource(new StringReader(SCHEMA_XXE_ATTACK)));
        Assert.assertNotNull((Object)schema);
    }

    @Test
    public void testSafeValidate() throws SAXException, IOException {
        Schema newSafeSchema = XmlUtils.newSafeSchemaFactory().newSchema(new StreamSource(new StringReader(SAFE_SCHEMA)));
        Assert.assertNotNull((Object)newSafeSchema);
        XmlUtils.safeValidate((Schema)newSafeSchema, (Source)new StreamSource(new StringReader(SAFE_DOCUMENT)));
    }

    @Test(expected=SAXException.class)
    public void testAttackValidate() throws SAXException, IOException {
        Schema newSafeSchema = XmlUtils.newSafeSchemaFactory().newSchema(new StreamSource(new StringReader(SAFE_SCHEMA)));
        Assert.assertNotNull((Object)newSafeSchema);
        XmlUtils.safeValidate((Schema)newSafeSchema, (Source)new StreamSource(new StringReader(GET_PASSWORD_ATTACK)));
    }

    @Test
    public void testNewSafeSaxParserFactory() throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory parserFactory = XmlUtils.newSafeSaxParserFactory();
        Assert.assertNotNull((Object)parserFactory);
        XMLReader xmlReader = parserFactory.newSAXParser().getXMLReader();
        Assert.assertNotNull((Object)xmlReader);
        xmlReader.parse(new InputSource(new StringReader(SAFE_DOCUMENT)));
    }

    @Test
    public void newSafeXmlStreamReader() throws XMLStreamException {
        XMLStreamReader reader = XmlUtils.newSafeXmlStreamReader((InputStream)new ByteArrayInputStream(SAFE_DOCUMENT.getBytes(StandardCharsets.UTF_8)));
        Assert.assertNotNull((Object)reader);
        Assert.assertEquals((long)1L, (long)reader.next());
    }
}

