/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfExperimentFolder
extends TmfProjectModelElement
implements IPropertySource2 {
    static final String EXPER_RESOURCE_NAME = "Experiments";
    private static final String INFO_CATEGORY = "Info";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String LOCATION = "location";
    private static final ReadOnlyTextPropertyDescriptor NAME_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("name", "name");
    private static final ReadOnlyTextPropertyDescriptor PATH_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("path", "path");
    private static final ReadOnlyTextPropertyDescriptor LOCATION_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("location", "location");
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{NAME_DESCRIPTOR, PATH_DESCRIPTOR, LOCATION_DESCRIPTOR};

    static {
        NAME_DESCRIPTOR.setCategory(INFO_CATEGORY);
        PATH_DESCRIPTOR.setCategory(INFO_CATEGORY);
        LOCATION_DESCRIPTOR.setCategory(INFO_CATEGORY);
    }

    public TmfExperimentFolder(String name, IFolder folder, TmfProjectElement parent) {
        super(name, (IResource)folder, parent);
    }

    public IFolder getResource() {
        return (IFolder)super.getResource();
    }

    @Override
    protected synchronized void refreshChildren() {
        IFolder folder = this.getResource();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element : this.getChildren()) {
            childrenMap.put(element.getResource().getName(), element);
        }
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    IFolder expFolder = (IFolder)resource;
                    String name = resource.getName();
                    ITmfProjectModelElement element = (ITmfProjectModelElement)childrenMap.get(name);
                    if (element instanceof TmfExperimentElement) {
                        childrenMap.remove(name);
                    } else {
                        element = new TmfExperimentElement(name, expFolder, this);
                        this.addChild(element);
                    }
                    ((TmfExperimentElement)element).refreshChildren();
                }
                ++n2;
            }
        }
        catch (CoreException members) {
            // empty catch block
        }
        for (ITmfProjectModelElement danglingChild : childrenMap.values()) {
            this.removeChild(danglingChild);
        }
    }

    @Override
    public Image getIcon() {
        return TmfProjectModelIcons.FOLDER_ICON;
    }

    @Override
    public String getLabelText() {
        return this.getName() + " [" + this.getChildren().size() + "]";
    }

    public List<TmfExperimentElement> getExperiments() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfExperimentElement> traces = new ArrayList<TmfExperimentElement>();
        for (ITmfProjectModelElement child : children) {
            if (!(child instanceof TmfExperimentElement)) continue;
            traces.add((TmfExperimentElement)child);
        }
        return traces;
    }

    public @Nullable TmfExperimentElement getExperiment(@NonNull IResource resource) {
        String name = resource.getName();
        if (name != null) {
            return this.getExperiment(name);
        }
        return null;
    }

    public @Nullable TmfExperimentElement getExperiment(@NonNull String name) {
        Optional<@NonNull TmfExperimentElement> exp = this.getExperiments().stream().filter(Objects::nonNull).filter(experiment -> experiment.getName().equals(name)).findFirst();
        return exp.isPresent() ? exp.get() : null;
    }

    public synchronized TmfExperimentElement addExperiment(@NonNull IFolder resource) {
        if (!resource.getParent().equals((Object)this.getResource())) {
            return null;
        }
        TmfExperimentElement experiment = this.getExperiment((IResource)resource);
        if (experiment != null) {
            return experiment;
        }
        String name = resource.getName();
        experiment = new TmfExperimentElement(name, resource, this);
        this.addChild(experiment);
        return experiment;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(DESCRIPTORS, DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        if (NAME.equals(id)) {
            return this.getName();
        }
        if (PATH.equals(id)) {
            return this.getPath().toString();
        }
        if (LOCATION.equals(id)) {
            return this.getLocation().toString();
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

