/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeSet;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCalledFunction;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public final class WeightedTreeUtils {
    private WeightedTreeUtils() {
    }

    public static <T> Collection<DifferentialWeightedTree<T>> diffTrees(Collection<WeightedTree<T>> first, Collection<WeightedTree<T>> second, @Nullable String statisticType) {
        ArrayList<DifferentialWeightedTree<T>> diffTrees = new ArrayList<DifferentialWeightedTree<T>>();
        for (WeightedTree<T> base : second) {
            Object object = base.getObject();
            WeightedTree<Object> other = WeightedTreeUtils.findObject(first, object);
            DifferentialWeightedTree<@NonNull Object> diffTree = WeightedTreeUtils.calculateDiffTree(object, base, other, statisticType);
            diffTrees.add(diffTree);
            for (DifferentialWeightedTree<T> childTree : WeightedTreeUtils.diffTrees(other == null ? Collections.emptyList() : other.getChildren(), base.getChildren(), null)) {
                diffTree.addChild(childTree);
            }
        }
        return diffTrees;
    }

    private static <T> DifferentialWeightedTree<@NonNull T> calculateDiffTree(@NonNull T object, WeightedTree<@NonNull T> base, @Nullable WeightedTree<@NonNull T> other, @Nullable String statisticType) {
        DifferentialWeightedTree<T> diffTree;
        double nullDiff = Double.NaN;
        if (statisticType == null) {
            double diffWeight = other == null ? nullDiff : (double)(base.getWeight() - other.getWeight()) / (double)other.getWeight();
            diffTree = new DifferentialWeightedTree<T>(base, object, base.getWeight(), diffWeight);
        } else {
            long baseWeight = 0L;
            long otherWeight = 0L;
            if (base instanceof AggregatedCalledFunction) {
                long[] weightsArray = WeightedTreeUtils.calculateWeights(base, other, statisticType);
                baseWeight = weightsArray[0];
                otherWeight = weightsArray[1];
            } else {
                baseWeight = base.getWeight();
                otherWeight = other == null ? 0L : other.getWeight();
            }
            double diffWeight = other == null || otherWeight == 0L ? nullDiff : (double)(baseWeight - otherWeight) / (double)otherWeight;
            diffTree = new DifferentialWeightedTree<T>(base, object, base.getWeight(), diffWeight);
        }
        return diffTree;
    }

    private static <T> long[] calculateWeights(WeightedTree<@NonNull T> base, @Nullable WeightedTree<@NonNull T> other, String statisticType) {
        long baseWeight = 0L;
        long otherWeight = 0L;
        long[] weightsArray = new long[2];
        switch (statisticType) {
            case "Self Time": {
                baseWeight = ((AggregatedCalledFunction)base).getSelfTime();
                otherWeight = other == null ? 0L : ((AggregatedCalledFunction)other).getSelfTime();
                break;
            }
            case "Duration": {
                baseWeight = ((AggregatedCalledFunction)base).getWeight();
                otherWeight = other == null ? 0L : ((AggregatedCalledFunction)other).getWeight();
                break;
            }
        }
        weightsArray[0] = baseWeight;
        weightsArray[1] = otherWeight;
        return weightsArray;
    }

    public static <N> @Nullable DifferentialWeightedTreeProvider<N> diffTreeSets(IWeightedTreeProvider<N, ?, WeightedTree<N>> provider, IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> first, IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> second) {
        Collection<Pair<@NonNull ?, @NonNull ?>> pairedElements = WeightedTreeUtils.pairElementsFromTrees(first, second);
        if (pairedElements.isEmpty()) {
            return null;
        }
        DifferentialWeightedTreeSet treeSet = new DifferentialWeightedTreeSet();
        for (Pair<?, ?> pair : pairedElements) {
            Collection trees1 = first.getTreesFor(pair.getFirst());
            Collection trees2 = second.getTreesFor(pair.getSecond());
            Collection diffTrees = WeightedTreeUtils.diffTrees(trees1, trees2, null);
            for (DifferentialWeightedTree tree : diffTrees) {
                treeSet.addWeightedTree(pair.getFirst(), tree);
            }
        }
        return new DifferentialWeightedTreeProvider<N>(provider, treeSet);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static <N> Collection<Pair<@NonNull ?, @NonNull ?>> pairElementsFromTrees(IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> first, IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> second) {
        Collection<Pair<?, ?>> pairedElements;
        @NonNull Collection elements1 = first.getElements();
        @NonNull Collection elements2 = second.getElements();
        if (elements1.size() == 1 && elements2.size() == 1) {
            @NonNull E element1 = elements1.iterator().next();
            @NonNull E element2 = elements2.iterator().next();
            if (!(element1 instanceof ITree) && !(element2 instanceof ITree)) {
                return ImmutableList.of((Object)new Pair(element1, element2));
            }
        }
        if (!(pairedElements = WeightedTreeUtils.pairEqualElements(elements1, elements2)).isEmpty()) {
            return pairedElements;
        }
        pairedElements = WeightedTreeUtils.pairSameNameElements(elements1, elements2);
        return pairedElements;
    }

    private static Collection<Pair<@NonNull ?, @NonNull ?>> pairEqualElements(Collection<@NonNull ?> elements1, Collection<@NonNull ?> elements2) {
        ArrayList<Pair<@NonNull ?, @NonNull ?>> pairedElements = new ArrayList();
        block0: for (Object element1 : elements1) {
            for (Object element2 : elements2) {
                if (!element1.equals(element2)) continue;
                pairedElements.add(new Pair(element1, element1));
                if (!(element1 instanceof ITree) || !(element2 instanceof ITree)) continue block0;
                pairedElements.addAll(WeightedTreeUtils.pairEqualElements(((ITree)element1).getChildren(), ((ITree)element2).getChildren()));
                continue block0;
            }
        }
        return pairedElements;
    }

    private static Collection<Pair<@NonNull ?, @NonNull ?>> pairSameNameElements(Collection<@NonNull ?> elements1, Collection<?> elements2) {
        ArrayList<Pair<@NonNull ?, @NonNull ?>> pairedElements = new ArrayList();
        block0: for (Object element1 : elements1) {
            if (!(element1 instanceof ITree)) continue;
            for (Object element2 : elements2) {
                if (!(element2 instanceof ITree) || !((ITree)element1).getName().equals(((ITree)element2).getName())) continue;
                pairedElements.add(new Pair(element1, element2));
                pairedElements.addAll(WeightedTreeUtils.pairSameNameElements(((ITree)element1).getChildren(), ((ITree)element2).getChildren()));
                continue block0;
            }
        }
        return pairedElements;
    }

    private static <T> @Nullable WeightedTree<T> findObject(Collection<WeightedTree<T>> tree, @NonNull T object) {
        for (WeightedTree<T> other : tree) {
            if (!other.getObject().equals(object)) continue;
            return other;
        }
        return null;
    }
}

