/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.ServerInfoResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ServerInfoResponseImpl;
import org.osgi.framework.Version;

@Path(value="/identifier")
@Tag(name="Identifier")
public class IdentifierService {
    private static final String OS_NAME = "os.name";
    private static final String OS_ARCH = "os.arch";
    private static final String OS_VERSION = "os.version";
    private static final String PRODUCT_ID = "eclipse.product";
    private static final String LAUNCHER_NAME = "eclipse.launcher.name";
    private static final String QUALIFIER = "qualifier";
    private static final String SEPARATOR = ".";
    private static final String HARD_CODED_VERSION = "0.8.1";

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves system and server information", responses={@ApiResponse(responseCode="200", description="Successfully retrieved the system and server information", content={@Content(mediaType="application/json", schema=@Schema(implementation=ServerInfoResponse.class))})})
    public Response getSystemInfo() {
        IProduct product = Platform.getProduct();
        ServerInfoResponseImpl response = new ServerInfoResponseImpl();
        response.setOs(System.getProperty(OS_NAME));
        response.setOsArch(System.getProperty(OS_ARCH));
        response.setOsVersion(System.getProperty(OS_VERSION));
        response.setCpuCount(Runtime.getRuntime().availableProcessors());
        response.setMaxMemory(Runtime.getRuntime().maxMemory());
        response.setProductId(System.getProperty(PRODUCT_ID));
        response.setLauncherName(System.getProperty(LAUNCHER_NAME));
        if (product != null) {
            Version version = product.getDefiningBundle().getVersion();
            response.setVersion(version.getMajor() + SEPARATOR + version.getMinor() + SEPARATOR + version.getMicro());
            String qualifier = version.getQualifier();
            if (!QUALIFIER.equalsIgnoreCase(qualifier) && qualifier != null) {
                response.setBuildTime(qualifier);
            }
        } else {
            response.setVersion(HARD_CODED_VERSION);
        }
        response.setTspVersion("0.3.1");
        return Response.ok((Object)response).build();
    }
}

