/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.ArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalEnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public abstract class ASTEnumerator
extends ASTAttributeOwner
implements IASTEnumerationSpecifier.IASTEnumerator,
IASTAmbiguityParent {
    private IASTName name;
    private IASTExpression value;
    private IValue integralValue;

    public ASTEnumerator() {
    }

    public ASTEnumerator(IASTName name, IASTExpression value) {
        this.setName(name);
        this.setValue(value);
    }

    @Override
    protected <T extends ASTEnumerator> T copy(T copy, IASTNode.CopyStyle style) {
        copy.setName(this.name == null ? null : this.name.copy(style));
        copy.setValue(this.value == null ? null : this.value.copy(style));
        return super.copy(copy, style);
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ENUMERATOR_NAME);
        }
    }

    @Override
    public IASTName getName() {
        return this.name;
    }

    @Override
    public void setValue(IASTExpression expression) {
        this.assertNotFrozen();
        this.value = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(ENUMERATOR_VALUE);
        }
    }

    @Override
    public IASTExpression getValue() {
        return this.value;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitEnumerators) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.value != null && !this.value.accept(action)) {
            return false;
        }
        if (action.shouldVisitEnumerators) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 2;
        }
        return 1;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.value) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.value = (IASTExpression)other;
        }
    }

    public IValue getIntegralValue() {
        if (this.integralValue == null) {
            IASTInternalEnumerationSpecifier enumeration;
            IASTNode parent = this.getParent();
            if (parent instanceof IASTInternalEnumerationSpecifier && (enumeration = (IASTInternalEnumerationSpecifier)parent).startValueComputation()) {
                ASTEnumerator.computeEnumValues(enumeration);
            }
            if (this.integralValue == null) {
                this.integralValue = IntegralValue.UNKNOWN;
            }
        }
        return this.integralValue;
    }

    private static void computeEnumValues(IASTInternalEnumerationSpecifier enumeration) {
        try {
            IASTEnumerationSpecifier.IASTEnumerator[] etors;
            IBinding binding;
            IType fixedType = null;
            if (enumeration instanceof ICPPASTEnumerationSpecifier && (binding = enumeration.getName().resolveBinding()) instanceof ICPPEnumeration) {
                fixedType = ((ICPPEnumeration)binding).getFixedType();
            }
            IType type = fixedType == null ? CPPBasicType.INT : null;
            IValue previousExplicitValue = null;
            int delta = 0;
            IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = etors = enumeration.getEnumerators();
            int n = etors.length;
            int n2 = 0;
            while (n2 < n) {
                IValue val;
                IASTEnumerationSpecifier.IASTEnumerator etor = iASTEnumeratorArray[n2];
                IBinding etorBinding = etor.getName().resolveBinding();
                IASTExpression expr = etor.getValue();
                if (expr != null) {
                    previousExplicitValue = val = ValueFactory.create(expr);
                    delta = 1;
                    if (fixedType == null) {
                        type = expr.getExpressionType();
                        type = SemanticUtil.getNestedType(type, 9);
                        if (etorBinding instanceof CPPEnumerator) {
                            ((CPPEnumerator)etorBinding).setInternalType(type);
                        }
                    }
                } else {
                    val = previousExplicitValue != null ? IntegralValue.incrementedValue(previousExplicitValue, delta) : IntegralValue.create(delta);
                    ++delta;
                    if (fixedType == null && type instanceof IBasicType) {
                        type = ASTEnumerator.getTypeOfIncrementedValue(type, val);
                        if (etorBinding instanceof CPPEnumerator) {
                            ((CPPEnumerator)etorBinding).setInternalType(type);
                        }
                    }
                }
                if (etor instanceof ASTEnumerator) {
                    ((ASTEnumerator)etor).integralValue = val;
                }
                ++n2;
            }
        }
        finally {
            enumeration.finishValueComputation();
        }
    }

    public static IBasicType getTypeOfIncrementedValue(IBasicType type, IValue val) {
        Number numericalValue = val.numberValue();
        if (numericalValue != null) {
            long longValue = numericalValue.longValue();
            if (type.getKind() != IBasicType.Kind.eInt && type.getKind() != IBasicType.Kind.eInt128 || type.isShort()) {
                IBasicType iBasicType = type = type.isUnsigned() ? CPPBasicType.UNSIGNED_INT : CPPBasicType.INT;
            }
            if (!ArithmeticConversion.fitsIntoType(type, longValue)) {
                if (!type.isUnsigned()) {
                    if (type.getKind() != IBasicType.Kind.eInt128) {
                        type = type.isLongLong() ? CPPBasicType.UNSIGNED_INT128 : (type.isLong() ? CPPBasicType.UNSIGNED_LONG_LONG : CPPBasicType.UNSIGNED_LONG);
                    }
                } else if (type.getKind() == IBasicType.Kind.eInt128) {
                    if (longValue >= 0L) {
                        type = CPPBasicType.UNSIGNED_INT128;
                    }
                } else {
                    type = type.isLongLong() ? CPPBasicType.INT128 : (type.isLong() ? CPPBasicType.LONG_LONG : CPPBasicType.LONG);
                }
            }
        }
        return type;
    }
}

