/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.properties;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.properties.AbstractSelectorPage;
import org.eclipse.swtchart.extensions.properties.Messages;
import org.eclipse.swtchart.extensions.properties.PropertiesResources;

public class GridPage
extends AbstractSelectorPage {
    private static final String GRID_FOREGROUND = "org.eclipse.swtchart.grid.foreground";
    private IAxis[] axes;
    protected Combo styleCombo;
    protected ColorSelector foregroundButton;
    protected LineStyle[] styles;
    protected RGB[] foregroundColors;

    public GridPage(InteractiveChart chart, PropertiesResources resources, IAxis.Direction direction, String title) {
        super(chart, resources, title, Messages.getString(Messages.AXES));
        if (direction == IAxis.Direction.X) {
            this.axes = chart.getAxisSet().getXAxes();
        } else if (direction == IAxis.Direction.Y) {
            this.axes = chart.getAxisSet().getYAxes();
        }
        this.styles = new LineStyle[this.axes.length];
        this.foregroundColors = new RGB[this.axes.length];
    }

    @Override
    protected String[] getListItems() {
        String[] items = new String[this.axes.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.axes[i].getId());
            ++i;
        }
        return items;
    }

    @Override
    protected void selectInitialValues() {
        int i = 0;
        while (i < this.axes.length) {
            this.styles[i] = this.axes[i].getGrid().getStyle();
            this.foregroundColors[i] = this.axes[i].getGrid().getForeground().getRGB();
            ++i;
        }
    }

    @Override
    protected void updateControlSelections() {
        this.styleCombo.setText(String.valueOf(this.styles[this.selectedIndex]));
        this.foregroundButton.setColorValue(this.foregroundColors[this.selectedIndex]);
    }

    @Override
    protected void addRightPanelContents(Composite parent) {
        this.addGridPanel(parent);
    }

    private void addGridPanel(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(2, false));
        this.createLabelControl(group, Messages.getString(Messages.LINE_STYLE));
        LineStyle[] values = LineStyle.values();
        String[] labels = new String[values.length];
        int i = 0;
        while (i < values.length) {
            labels[i] = values[i].label();
            ++i;
        }
        this.styleCombo = this.createComboControl(group, labels);
        this.styleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = GridPage.this.styleCombo.getText();
                LineStyle selectedStyle = LineStyle.NONE;
                LineStyle[] lineStyleArray = LineStyle.values();
                int n = lineStyleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LineStyle style = lineStyleArray[n2];
                    if (style.label().equals(value)) {
                        selectedStyle = style;
                    }
                    ++n2;
                }
                GridPage.this.styles[GridPage.this.selectedIndex] = selectedStyle;
            }
        });
        this.createLabelControl(group, Messages.getString(Messages.COLOR));
        this.foregroundButton = this.createColorButtonControl(group);
        this.foregroundButton.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                GridPage.this.foregroundColors[GridPage.this.selectedIndex] = GridPage.this.foregroundButton.getColorValue();
            }
        });
    }

    @Override
    public void apply() {
        int i = 0;
        while (i < this.axes.length) {
            this.axes[i].getGrid().setStyle(this.styles[i]);
            Color color = ResourceSupport.getColor(this.foregroundColors[i]);
            this.axes[i].getGrid().setForeground(color);
            this.resources.put(GRID_FOREGROUND + this.axes[i].getDirection() + this.axes[i].getId(), color);
            ++i;
        }
    }

    protected void performDefaults() {
        this.styles[this.selectedIndex] = LineStyle.DOT;
        this.foregroundColors[this.selectedIndex] = Display.getDefault().getSystemColor(15).getRGB();
        this.updateControlSelections();
        super.performDefaults();
    }
}

