/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.eval;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptThread;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.EvaluationManager;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.RunToLineAdapter;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.StepIntoSelectionHandler;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.StepIntoSelectionUtils;

public class StepIntoSelectionActionDelegate
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private IEditorPart editor = null;
    private IWorkbenchWindow window = null;
    private IRegion region = null;
    private int line = -1;
    private IDebugEventSetListener listener = null;

    public StepIntoSelectionActionDelegate() {
    }

    public StepIntoSelectionActionDelegate(IRegion region) {
        this.region = region;
    }

    public void run(IAction action) {
        IJavaScriptStackFrame frame = this.getStackFrame();
        if (frame == null || !frame.isSuspended()) {
            return;
        }
        ITextSelection textSelection = this.getTextSelection();
        try {
            IEditorPart activeEditor = this.getActiveEditor();
            IJavaScriptElement javaElement = StepIntoSelectionUtils.getJavaElement(activeEditor.getEditorInput());
            IFunction function = StepIntoSelectionUtils.getFunction(textSelection, javaElement);
            if (function == null) {
                function = StepIntoSelectionUtils.getFirstFunctionOnLine(textSelection.getOffset(), activeEditor, javaElement);
            }
            int lineNumber = frame.getLineNumber();
            if (textSelection.getStartLine() != lineNumber - 1) {
                this.runToLineBeforeStepIn(textSelection, frame.getThread(), function);
                return;
            }
            this.doStepIn(frame, function);
        }
        catch (DebugException e) {
            this.showErrorMessage(e.getStatus().getMessage());
            return;
        }
        catch (JavaScriptModelException jme) {
            this.showErrorMessage(jme.getStatus().getMessage());
            return;
        }
    }

    private void doStepIn(IJavaScriptStackFrame frame, IFunction function) throws DebugException {
        IStackFrame tos = frame.getThread().getTopStackFrame();
        if (tos == null) {
            return;
        }
        if (!tos.equals(frame)) {
            this.showErrorMessage(Messages.step_into_only_top_frame);
            return;
        }
        StepIntoSelectionHandler handler = new StepIntoSelectionHandler((IJavaScriptThread)frame.getThread(), frame, function);
        handler.step();
    }

    private void runToLineBeforeStepIn(ITextSelection textSelection, final IThread thread, final IFunction function) {
        IAdapterManager adapterManager;
        this.line = textSelection.getStartLine() + 1;
        if (this.line == -1) {
            return;
        }
        IRunToLineTarget runToLineAction = null;
        IEditorPart ed = this.getActiveEditor();
        if (ed != null && (runToLineAction = (IRunToLineTarget)ed.getAdapter(IRunToLineTarget.class)) == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)ed, IRunToLineTarget.class.getName())) {
            runToLineAction = (IRunToLineTarget)adapterManager.loadAdapter((Object)ed, IRunToLineTarget.class.getName());
        }
        if (runToLineAction == null) {
            runToLineAction = new RunToLineAdapter();
        }
        this.listener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    switch (event.getKind()) {
                        case 2: {
                            this.handleSuspendEvent(event);
                            break;
                        }
                        case 8: {
                            this.handleTerminateEvent(event);
                            break;
                        }
                    }
                    ++i;
                }
            }

            private void handleSuspendEvent(DebugEvent event) {
                Object source = event.getSource();
                if (source instanceof IJavaScriptThread) {
                    try {
                        final IJavaScriptStackFrame frame = (IJavaScriptStackFrame)((IJavaScriptThread)source).getTopStackFrame();
                        if (this.isExpectedFrame(frame)) {
                            DebugPlugin plugin = DebugPlugin.getDefault();
                            plugin.removeDebugEventListener(StepIntoSelectionActionDelegate.this.listener);
                            plugin.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        StepIntoSelectionActionDelegate.this.doStepIn(frame, function);
                                    }
                                    catch (DebugException e) {
                                        StepIntoSelectionActionDelegate.this.showErrorMessage(e.getStatus().getMessage());
                                    }
                                }
                            });
                        }
                    }
                    catch (DebugException debugException) {
                        return;
                    }
                }
            }

            private boolean isExpectedFrame(IJavaScriptStackFrame frame) throws DebugException {
                return frame != null && StepIntoSelectionActionDelegate.this.line == frame.getLineNumber();
            }

            private void handleTerminateEvent(DebugEvent event) {
                Object source = event.getSource();
                if (thread.getDebugTarget() == source) {
                    DebugPlugin.getDefault().removeDebugEventListener(StepIntoSelectionActionDelegate.this.listener);
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.listener);
        try {
            runToLineAction.runToLine((IWorkbenchPart)this.getActiveEditor(), (ISelection)textSelection, (ISuspendResume)thread);
        }
        catch (CoreException e) {
            DebugPlugin.getDefault().removeDebugEventListener(this.listener);
            this.showErrorMessage(Messages.exception_running_to_line);
            JavaScriptDebugUIPlugin.log(e.getStatus());
        }
    }

    private ITextSelection getTextSelection() {
        IEditorPart part = this.getActiveEditor();
        if (part instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)part;
            if (this.region != null) {
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                if (document != null) {
                    return new TextSelection(document, this.region.getOffset(), this.region.getLength());
                }
            } else {
                return (ITextSelection)editor.getSelectionProvider().getSelection();
            }
        }
        this.showErrorMessage(Messages.only_in_the_js_editor);
        return null;
    }

    protected void showErrorMessage(String message) {
        IEditorStatusLine statusLine;
        if (this.getActiveEditor() != null && (statusLine = (IEditorStatusLine)this.getActiveEditor().getAdapter(IEditorStatusLine.class)) != null) {
            statusLine.setMessage(true, message, null);
        }
        JavaScriptDebugUIPlugin.getStandardDisplay().beep();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor;
    }

    protected IEditorPart getActiveEditor() {
        if (this.window != null) {
            return this.window.getActivePage().getActiveEditor();
        }
        return this.editor;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IJavaScriptStackFrame getStackFrame() {
        return EvaluationManager.getManager().getEvaluationContext((IWorkbenchPart)this.getActiveEditor());
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

