/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.signal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.analysis.signal.SignalModifier;
import org.eclipse.trace4cps.analysis.signal.impl.EventSignalUtil;
import org.eclipse.trace4cps.analysis.signal.impl.LinearSignalFragment;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.Interval;
import org.eclipse.trace4cps.core.impl.TraceHelper;

public class SignalUtil {
    private SignalUtil() {
    }

    public static double convert(TimeUnit dst, double v, TimeUnit src) {
        double w = v * (double)dst.convert(1L, src);
        if (w == 0.0) {
            w = v / (double)src.convert(1L, dst);
        }
        return w;
    }

    private static double getTraceWindowWidth(TimeUnit traceTimeUnit, double windowWidth, TimeUnit windowTimeUnit) {
        return SignalUtil.convert(traceTimeUnit, windowWidth, windowTimeUnit);
    }

    public static IPsop getLatency(ITrace trace, String idAttribute, TimeUnit scaleUnit, double windowWidth, TimeUnit windowUnit) {
        double scaleFactor = SignalUtil.convert(scaleUnit, 1.0, trace.getTimeUnit());
        SignalModifier mod = new SignalModifier(scaleFactor, windowWidth, windowUnit);
        List<LinearSignalFragment> wip = SignalUtil.createWipEventSignal(trace, idAttribute);
        List<LinearSignalFragment> tp = SignalUtil.createTpEventSignal(trace, idAttribute);
        List<LinearSignalFragment> lat = EventSignalUtil.divide(wip, tp, 0.0);
        if (mod.appliesConvolution()) {
            return SignalUtil.applyConvolution(trace.getTimeUnit(), TraceHelper.getDomain(trace), mod, lat);
        }
        return EventSignalUtil.toIPsop(EventSignalUtil.scale(lat, mod.getScale()));
    }

    public static IPsop getTP(ITrace trace, String idAtt, TimeUnit scaleUnit, double windowWidth, TimeUnit windowUnit) {
        double scaleFactor = SignalUtil.convert(trace.getTimeUnit(), 1.0, scaleUnit);
        SignalModifier mod = new SignalModifier(scaleFactor, windowWidth, windowUnit);
        return SignalUtil.modifySignal(trace.getTimeUnit(), TraceHelper.getDomain(trace), SignalUtil.createTpEventSignal(trace, idAtt), mod);
    }

    public static IPsop getTP(TimeUnit traceTimeUnit, IInterval dom, List<IEvent> events, TimeUnit scaleUnit, double windowWidth, TimeUnit windowUnit) {
        double scaleFactor = SignalUtil.convert(traceTimeUnit, 1.0, scaleUnit);
        SignalModifier mod = new SignalModifier(scaleFactor, windowWidth, windowUnit);
        if (!mod.appliesConvolution()) {
            throw new IllegalArgumentException("instantaneous event-based tp not supported");
        }
        return SignalUtil.modifySignal(traceTimeUnit, dom, SignalUtil.createTpEventSignal(events), mod);
    }

    public static IPsop getWip(ITrace trace, String idAtt, SignalModifier mod) {
        return SignalUtil.modifySignal(trace.getTimeUnit(), TraceHelper.getDomain(trace), SignalUtil.createWipEventSignal(trace, idAtt), mod);
    }

    public static IPsop getResourceClients(ITrace trace, IResource resource, SignalModifier mod) {
        return SignalUtil.modifySignal(trace.getTimeUnit(), TraceHelper.getDomain(trace), SignalUtil.createResourceUtilizationSignal(trace, resource), mod);
    }

    public static IPsop getResourceAmount(ITrace trace, IResource resource, SignalModifier mod) {
        return SignalUtil.modifySignal(trace.getTimeUnit(), TraceHelper.getDomain(trace), SignalUtil.createResourceAmountSignal(trace, resource), mod);
    }

    private static IPsop modifySignal(TimeUnit traceTimeUnit, IInterval dom, List<LinearSignalFragment> events, SignalModifier mod) {
        if (mod.appliesConvolution()) {
            return SignalUtil.applyConvolution(traceTimeUnit, dom, mod, events);
        }
        return SignalUtil.applyInstantaneous(dom, mod, events);
    }

    private static IPsop applyInstantaneous(IInterval dom, SignalModifier mod, List<LinearSignalFragment> events) {
        List<LinearSignalFragment> inst = EventSignalUtil.computeInstantaneous(events, mod.getScale(), dom);
        return EventSignalUtil.toIPsop(inst);
    }

    private static IPsop applyConvolution(TimeUnit traceTimeUnit, IInterval tdom, SignalModifier mod, List<LinearSignalFragment> lsfs) {
        double scale = mod.getScale();
        double w = SignalUtil.getTraceWindowWidth(traceTimeUnit, mod.getWindowWidth(), mod.getWindowTimeUnit());
        Interval dom = new Interval(tdom.lb(), false, tdom.ub().doubleValue() + w * 1.1, true);
        return EventSignalUtil.convoluteScaleAndProject(lsfs, scale, w, dom);
    }

    private static List<LinearSignalFragment> createWipEventSignal(ITrace trace, String idAtt) {
        Map<String, double[]> timeStampsAndValue = SignalUtil.createTimeStampValueMap(trace, idAtt);
        ArrayList<LinearSignalFragment> events = new ArrayList<LinearSignalFragment>();
        for (Map.Entry<String, double[]> e : timeStampsAndValue.entrySet()) {
            double[] ts = e.getValue();
            events.add(new LinearSignalFragment(ts[0], ts[1], 1.0, 1.0));
        }
        EventSignalUtil.sortStartAsc(events);
        return events;
    }

    private static List<LinearSignalFragment> createTpEventSignal(ITrace trace, String idAtt) {
        Map<String, double[]> timeStampsAndValue = SignalUtil.createTimeStampValueMap(trace, idAtt);
        ArrayList<LinearSignalFragment> events = new ArrayList<LinearSignalFragment>();
        for (Map.Entry<String, double[]> e : timeStampsAndValue.entrySet()) {
            double[] ts = e.getValue();
            double val = 1.0 / (ts[1] - ts[0]);
            events.add(new LinearSignalFragment(ts[0], ts[1], val, val));
        }
        EventSignalUtil.sortStartAsc(events);
        return events;
    }

    private static List<LinearSignalFragment> createTpEventSignal(List<IEvent> list) {
        ArrayList<LinearSignalFragment> events = new ArrayList<LinearSignalFragment>();
        for (IEvent e : list) {
            events.add(new LinearSignalFragment(e.getTimestamp().doubleValue(), 1.0));
        }
        return events;
    }

    private static Map<String, double[]> createTimeStampValueMap(ITrace trace, String idAtt) {
        HashMap<String, double[]> timeStampsAndValue = new HashMap<String, double[]>();
        for (IEvent e : trace.getEvents()) {
            if (e.getAttributeValue(idAtt) == null) continue;
            double[] vals = SignalUtil.getOrCreate(idAtt, timeStampsAndValue, e);
            vals[0] = Math.min(vals[0], e.getTimestamp().doubleValue());
            vals[1] = Math.max(vals[1], e.getTimestamp().doubleValue());
        }
        return timeStampsAndValue;
    }

    private static double[] getOrCreate(String idAtt, Map<String, double[]> timeStampsAndValue, IEvent e) {
        String key = SignalUtil.createObjectKey(idAtt, e);
        double[] stamps = timeStampsAndValue.get(key);
        if (stamps == null) {
            stamps = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
            timeStampsAndValue.put(key, stamps);
        }
        return stamps;
    }

    private static String createObjectKey(String idAtt, IEvent e) {
        String v = e.getAttributeValue(idAtt);
        Integer val = null;
        try {
            if (v == null) {
                throw new IllegalStateException("event " + String.valueOf(e) + " has no integer id attribute " + idAtt);
            }
            val = Integer.parseInt(v);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("event " + String.valueOf(e) + " has no integer id attribute " + idAtt);
        }
        return idAtt + "=" + String.valueOf(val);
    }

    private static List<LinearSignalFragment> createResourceUtilizationSignal(ITrace trace, IResource resource) {
        ArrayList<LinearSignalFragment> events = new ArrayList<LinearSignalFragment>();
        for (IClaim c : trace.getClaims()) {
            if (!c.getResource().equals(resource)) continue;
            events.add(new LinearSignalFragment(c.getStartTime().doubleValue(), c.getEndTime().doubleValue(), 1.0, 1.0));
        }
        EventSignalUtil.sortStartAsc(events);
        return events;
    }

    private static List<LinearSignalFragment> createResourceAmountSignal(ITrace trace, IResource resource) {
        ArrayList<LinearSignalFragment> events = new ArrayList<LinearSignalFragment>();
        for (IClaim c : trace.getClaims()) {
            double v;
            if (!c.getResource().equals(resource) || !((v = c.getAmount().doubleValue()) > 0.0)) continue;
            events.add(new LinearSignalFragment(c.getStartTime().doubleValue(), c.getEndTime().doubleValue(), v, v));
        }
        EventSignalUtil.sortStartAsc(events);
        return events;
    }
}

