/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.stl.impl;

import java.util.Arrays;
import java.util.List;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.stl.StlFormula;
import org.eclipse.trace4cps.analysis.stl.impl.AbstractStlFormula;
import org.eclipse.trace4cps.analysis.stl.impl.STLUtil;
import org.eclipse.trace4cps.analysis.stl.impl.StlTrue;
import org.eclipse.trace4cps.core.IPsop;

public class StlUntil
extends AbstractStlFormula {
    private final StlFormula f1;
    private final StlFormula f2;
    private final double a;
    private final double b;

    public StlFormula getLeft() {
        return this.f1;
    }

    public StlFormula getRight() {
        return this.f2;
    }

    public StlUntil(StlFormula f1, StlFormula f2, double a, double b) {
        if (b <= a) {
            throw new IllegalArgumentException("b must be larger than a");
        }
        this.f1 = f1;
        this.f2 = f2;
        this.a = a;
        this.b = b;
    }

    public boolean isUntimed() {
        return this.a == 0.0 && this.b == Double.POSITIVE_INFINITY;
    }

    @Override
    public List<MtlFormula> getChildren() {
        return Arrays.asList(this.f1, this.f2);
    }

    @Override
    protected IPsop computeSignal() {
        if (this.f1 instanceof StlTrue) {
            return STLUtil.signal_eventually(this.f2.getSignal(), this.a, this.b);
        }
        throw new UnsupportedOperationException("general Until is not supported");
    }

    public String toString() {
        return "(" + this.f1 + " U_[" + this.a + "," + this.b + "] " + this.f2 + ")";
    }
}

