/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.ui.internal.utils.MarkerConfig;
import org.eclipse.tm4e.ui.internal.utils.ResourceUtils;

public final class MarkerUtils {
    private static final String TEXTMARKER_TYPE = "org.eclipse.tm4e.ui.textmarker";
    private static final String PROBLEMMARKER_TYPE = "org.eclipse.tm4e.ui.problemmarker";
    private static final String TASKMARKER_TYPE = "org.eclipse.tm4e.ui.taskmarker";
    private static final Map<String, MarkerConfig> MARKERCONFIG_BY_TAG = new HashMap<String, MarkerConfig>();
    private static Pattern TAG_SELECTOR_PATTERN = (Pattern)NullSafetyHelper.lazyNonNull();

    static {
        MarkerUtils.reloadMarkerConfigs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadMarkerConfigs() {
        Map<String, MarkerConfig> map = MARKERCONFIG_BY_TAG;
        synchronized (map) {
            MARKERCONFIG_BY_TAG.clear();
            for (MarkerConfig markerConfig : PreferenceHelper.loadMarkerConfigs()) {
                MARKERCONFIG_BY_TAG.put(markerConfig.tag, markerConfig);
            }
            TAG_SELECTOR_PATTERN = Pattern.compile("^\\s*(" + MARKERCONFIG_BY_TAG.keySet().stream().collect(Collectors.joining("|")) + ")\\b");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void updateTextMarkers(ModelTokensChangedEvent event) {
        ITMModel model = event.model;
        ITMModel iTMModel = model;
        if (iTMModel instanceof TMDocumentModel) {
            TMDocumentModel tMDocumentModel = (TMDocumentModel)iTMModel;
            TMDocumentModel cfr_ignored_0 = (TMDocumentModel)iTMModel;
            try {
                void docModel;
                MarkerUtils.updateTextMarkers((TMDocumentModel)docModel, ((Range)event.ranges.get((int)0)).fromLineNumber);
            }
            catch (CoreException ex) {
                TMUIPlugin.logError((Exception)((Object)ex));
            }
        }
    }

    private static void updateTextMarkers(TMDocumentModel docModel, int startLineNumber) throws CoreException {
        IDocument doc = docModel.getDocument();
        IResource res = ResourceUtils.findResource(doc);
        if (res == null) {
            return;
        }
        int numberOfLines = docModel.getNumberOfLines();
        HashMap markers = new HashMap();
        IMarker[] iMarkerArray = res.findMarkers(TEXTMARKER_TYPE, true, 0);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            Integer lineNumberObj = MarkerUtils.getLineNumber(marker);
            if (lineNumberObj == null) {
                marker.delete();
            } else {
                int lineNumber = lineNumberObj;
                if (lineNumber >= startLineNumber) {
                    if (lineNumber > numberOfLines) {
                        marker.delete();
                    } else {
                        List markersOfLine = markers.computeIfAbsent(lineNumberObj, l -> new ArrayList(1));
                        markersOfLine.add(marker);
                    }
                }
            }
            ++n2;
        }
        int lineNumber = startLineNumber;
        while (lineNumber <= numberOfLines) {
            Integer lineNumberObj = lineNumber;
            int lineIndex = lineNumber - 1;
            List tokens = (List)NullSafetyHelper.castNonNull((Object)docModel.getLineTokens(lineIndex));
            int tokensCount = tokens.size();
            List<IMarker> outdatedMarkers = markers.getOrDefault(lineNumberObj, Collections.emptyList());
            int tokenIndex = 0;
            while (tokenIndex < tokensCount) {
                TMToken token = (TMToken)tokens.get(tokenIndex);
                if (token.type.contains("comment") && !token.type.contains("definition")) {
                    TMToken nextToken = tokenIndex + 1 < tokensCount ? (TMToken)tokens.get(tokenIndex + 1) : null;
                    try {
                        Matcher matcher;
                        int lineOffset = doc.getLineOffset(lineIndex);
                        String commentText = doc.get(lineOffset + token.startIndex, (nextToken == null ? doc.getLineLength(lineIndex) : nextToken.startIndex) - token.startIndex);
                        if (commentText.length() >= 3 && (matcher = TAG_SELECTOR_PATTERN.matcher(commentText)).find()) {
                            MarkerConfig markerConfig = MARKERCONFIG_BY_TAG.get(matcher.group(1));
                            String markerText = commentText.substring(matcher.start()).trim();
                            HashMap<String, Object> attrs = new HashMap<String, Object>();
                            attrs.put("lineNumber", lineNumberObj);
                            attrs.put("message", markerText);
                            switch (markerConfig.type) {
                                case PROBLEM: {
                                    attrs.put("severity", markerConfig.asProblemMarkerConfig().severity.value);
                                    break;
                                }
                                case TASK: {
                                    attrs.put("priority", markerConfig.asTaskMarkerConfig().priority.value);
                                }
                            }
                            attrs.put("userEditable", Boolean.FALSE);
                            attrs.put("sourceId", "TM4E");
                            String markerTypeId = switch (markerConfig.type) {
                                case MarkerConfig.Type.PROBLEM -> PROBLEMMARKER_TYPE;
                                case MarkerConfig.Type.TASK -> TASKMARKER_TYPE;
                                default -> throw new IncompatibleClassChangeError();
                            };
                            if (!MarkerUtils.removeMatchingMarker(outdatedMarkers, markerTypeId, attrs)) {
                                int markerTextStartOffset = lineOffset + token.startIndex + matcher.start();
                                attrs.put("charStart", markerTextStartOffset);
                                attrs.put("charEnd", markerTextStartOffset + markerText.length());
                                res.createMarker(markerTypeId, attrs);
                            }
                        }
                    }
                    catch (Exception ex) {
                        TMUIPlugin.logError(ex);
                    }
                }
                ++tokenIndex;
            }
            if (!outdatedMarkers.isEmpty()) {
                for (IMarker marker : outdatedMarkers) {
                    marker.delete();
                }
            }
            ++lineNumber;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable Integer getLineNumber(IMarker marker) {
        try {
            Object lineNumberAttr;
            Object object = lineNumberAttr = marker.getAttribute("lineNumber");
            if (object instanceof Integer) {
                void lineNumber;
                Integer n = (Integer)object;
                Integer cfr_ignored_0 = (Integer)object;
                return lineNumber;
            }
        }
        catch (CoreException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
        }
        return null;
    }

    private static boolean removeMatchingMarker(List<IMarker> markers, String type, Map<String, ?> attributes) throws CoreException {
        if (markers.isEmpty()) {
            return false;
        }
        Iterator<IMarker> it = markers.iterator();
        while (it.hasNext()) {
            IMarker marker = it.next();
            if (!marker.getType().equals(type)) continue;
            boolean hasMatchingAttrs = true;
            for (Map.Entry<String, ?> attr : attributes.entrySet()) {
                if (Objects.equals(marker.getAttribute(attr.getKey()), attr.getValue())) continue;
                hasMatchingAttrs = false;
                break;
            }
            if (!hasMatchingAttrs) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private MarkerUtils() {
    }
}

