/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.grammar.BalancedBracketSelectors;
import org.eclipse.tm4e.core.internal.grammar.Grammar;
import org.eclipse.tm4e.core.internal.grammar.RawRule;
import org.eclipse.tm4e.core.internal.registry.IGrammarRepository;
import org.eclipse.tm4e.core.internal.theme.IThemeProvider;
import org.eclipse.tm4e.core.internal.theme.Theme;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElementRule;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.internal.types.IRawRepository;
import org.eclipse.tm4e.core.internal.types.IRawRule;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class SyncRegistry
implements IGrammarRepository,
IThemeProvider {
    private final Map<String, Grammar> grammars = new HashMap<String, Grammar>();
    private final Map<@Nullable String, IRawGrammar> rawGrammars = new HashMap<String, IRawGrammar>();
    private final Map<@Nullable String, Collection<String>> injectionGrammars = new HashMap<String, Collection<String>>();
    private Theme theme;

    public SyncRegistry(Theme theme) {
        this.theme = theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.grammars.values().forEach(Grammar::onDidChangeTheme);
    }

    public Set<String> getColorMap() {
        return this.theme.getColorMap();
    }

    public Collection<String> addGrammar(IRawGrammar grammar, @Nullable Collection<String> injectionScopeNames) {
        this.rawGrammars.put(grammar.getScopeName(), grammar);
        ArrayList<String> includedScopes = new ArrayList<String>();
        SyncRegistry.collectIncludedScopes(includedScopes, grammar);
        if (injectionScopeNames != null) {
            this.injectionGrammars.put(grammar.getScopeName(), injectionScopeNames);
            injectionScopeNames.forEach(scopeName -> SyncRegistry.addIncludedScope(scopeName, includedScopes));
        }
        return includedScopes;
    }

    @Override
    public @Nullable IRawGrammar lookup(String scopeName) {
        return this.rawGrammars.get(scopeName);
    }

    @Override
    public @Nullable Collection<String> injections(String targetScope) {
        return this.injectionGrammars.get(targetScope);
    }

    @Override
    public ThemeTrieElementRule getDefaults() {
        return this.theme.getDefaults();
    }

    @Override
    public List<ThemeTrieElementRule> themeMatch(String scopeName) {
        return this.theme.match(scopeName);
    }

    public @Nullable IGrammar grammarForScopeName(String scopeName, int initialLanguage, @Nullable Map<String, Integer> embeddedLanguages, @Nullable Map<String, Integer> tokenTypes, @Nullable BalancedBracketSelectors balancedBracketSelectors) {
        if (!this.grammars.containsKey(scopeName)) {
            IRawGrammar rawGrammar = this.lookup(scopeName);
            if (rawGrammar == null) {
                return null;
            }
            this.grammars.put(scopeName, new Grammar(scopeName, rawGrammar, initialLanguage, embeddedLanguages, tokenTypes, balancedBracketSelectors, this, this));
        }
        return this.grammars.get(scopeName);
    }

    private static void collectIncludedScopes(Collection<String> result, IRawGrammar grammar) {
        Collection<IRawRule> grammarPatterns = grammar.getPatterns();
        if (grammarPatterns != null) {
            SyncRegistry.extractIncludedScopesInPatterns(result, grammarPatterns);
        }
        if (grammar.isRepositorySet()) {
            IRawRepository repository = grammar.getRepository();
            SyncRegistry.extractIncludedScopesInRepository(result, repository);
        }
        result.remove(grammar.getScopeName());
    }

    private static void extractIncludedScopesInPatterns(Collection<String> result, Collection<IRawRule> patterns) {
        for (IRawRule pattern : patterns) {
            String include;
            Collection<IRawRule> p = pattern.getPatterns();
            if (p != null) {
                SyncRegistry.extractIncludedScopesInPatterns(result, p);
            }
            if ((include = pattern.getInclude()) == null || include.equals("$base") || include.equals("$self") || include.charAt(0) == '#') continue;
            int sharpIndex = include.indexOf(35);
            if (sharpIndex >= 0) {
                SyncRegistry.addIncludedScope(include.substring(0, sharpIndex), result);
                continue;
            }
            SyncRegistry.addIncludedScope(include, result);
        }
    }

    private static void addIncludedScope(String scopeName, Collection<String> includedScopes) {
        if (!includedScopes.contains(scopeName)) {
            includedScopes.add(scopeName);
        }
    }

    private static void extractIncludedScopesInRepository(Collection<String> result, IRawRepository repository) {
        if (!(repository instanceof RawRule)) {
            return;
        }
        RawRule rawRepository = (RawRule)((Object)repository);
        for (Object entry : rawRepository.values()) {
            IRawRepository repo;
            IRawRule rule = (IRawRule)NullSafetyHelper.castNonNull(entry);
            Collection<IRawRule> patterns = rule.getPatterns();
            if (patterns != null) {
                SyncRegistry.extractIncludedScopesInPatterns(result, patterns);
            }
            if ((repo = rule.getRepository()) == null) continue;
            SyncRegistry.extractIncludedScopesInRepository(result, repo);
        }
    }
}

