/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ColorMap {
    private int lastColorId = 0;
    private final Map<String, Integer> color2id = new HashMap<String, Integer>();

    public int getId(String color) {
        if (color == null) {
            return 0;
        }
        Integer value = this.color2id.get(color = color.toUpperCase());
        if (value != null) {
            return value;
        }
        value = ++this.lastColorId;
        this.color2id.put(color, value);
        return value;
    }

    public String getColor(int id) {
        for (Map.Entry<String, Integer> entry : this.color2id.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<String> getColorMap() {
        return this.color2id.keySet();
    }

    public int hashCode() {
        return Objects.hash(this.color2id, this.lastColorId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorMap other = (ColorMap)obj;
        return Objects.equals(this.color2id, other.color2id) && this.lastColorId == other.lastColorId;
    }
}

