/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.registry.Registry;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.internal.GrammarCache;

public abstract class AbstractGrammarRegistryManager
extends Registry
implements IGrammarRegistryManager {
    protected final GrammarCache pluginCache = new GrammarCache();
    protected final GrammarCache userCache = new GrammarCache();

    public AbstractGrammarRegistryManager() {
        this(new EclipseRegistryOptions());
        ((EclipseRegistryOptions)this.getLocator()).setRegistry(this);
    }

    public AbstractGrammarRegistryManager(IRegistryOptions locator) {
        super(locator);
    }

    @Override
    public IGrammar getGrammarFor(IContentType[] contentTypes) {
        if (contentTypes == null) {
            return null;
        }
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IGrammar grammar;
            IContentType contentType = iContentTypeArray[n2];
            String scopeName = this.getScopeNameForContentType(contentType.getId());
            if (scopeName != null && (grammar = this.getGrammarForScope(scopeName)) != null) {
                return grammar;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IGrammar getGrammarForScope(String scopeName) {
        return this.getGrammar(scopeName);
    }

    @Override
    public IGrammar getGrammarForFileType(String fileType) {
        IGrammarDefinition[] definitions = this.getDefinitions();
        if (fileType.startsWith(".")) {
            fileType = fileType.substring(1);
        }
        IGrammarDefinition[] iGrammarDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Collection fileTypes;
            IGrammarDefinition definition = iGrammarDefinitionArray[n2];
            IGrammar grammar = this.getGrammarForScope(definition.getScopeName());
            if (grammar != null && (fileTypes = grammar.getFileTypes()).contains(fileType)) {
                return grammar;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IGrammarDefinition[] getDefinitions() {
        Collection<IGrammarDefinition> pluginDefinitions = this.pluginCache.getDefinitions();
        Collection<IGrammarDefinition> userDefinitions = this.userCache.getDefinitions();
        ArrayList<IGrammarDefinition> definitions = new ArrayList<IGrammarDefinition>(pluginDefinitions);
        definitions.addAll(userDefinitions);
        return definitions.toArray(new IGrammarDefinition[definitions.size()]);
    }

    public IGrammar getGrammar(String scopeName) {
        if (scopeName == null) {
            return null;
        }
        IGrammar grammar = super.grammarForScopeName(scopeName);
        if (grammar != null) {
            return grammar;
        }
        return super.loadGrammar(scopeName);
    }

    public IGrammarDefinition getDefinition(String scopeName) {
        IGrammarDefinition definition = this.userCache.getDefinition(scopeName);
        if (definition != null) {
            return definition;
        }
        return this.pluginCache.getDefinition(scopeName);
    }

    @Override
    public Collection<String> getInjections(String scopeName) {
        return this.pluginCache.getInjections(scopeName);
    }

    public void registerInjection(String scopeName, String injectTo) {
        this.pluginCache.registerInjection(scopeName, injectTo);
    }

    public String getScopeNameForContentType(String contentTypeId) {
        return this.pluginCache.getScopeNameForContentType(contentTypeId);
    }

    @Override
    public String[] getContentTypesForScope(String scopeName) {
        return this.pluginCache.getContentTypesForScope(scopeName);
    }

    public void registerContentTypeBinding(String contentTypeId, String scopeName) {
        this.pluginCache.registerContentTypeBinding(contentTypeId, scopeName);
    }

    @Override
    public void registerGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userCache.registerGrammarDefinition(definition);
        } else {
            this.pluginCache.registerGrammarDefinition(definition);
        }
    }

    @Override
    public void unregisterGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userCache.unregisterGrammarDefinition(definition);
        } else {
            this.pluginCache.unregisterGrammarDefinition(definition);
        }
    }

    private static class EclipseRegistryOptions
    implements IRegistryOptions {
        private AbstractGrammarRegistryManager registry;

        private EclipseRegistryOptions() {
        }

        public void setRegistry(AbstractGrammarRegistryManager registry) {
            this.registry = registry;
        }

        public Collection<String> getInjections(String scopeName) {
            return this.registry.getInjections(scopeName);
        }

        public String getFilePath(String scopeName) {
            IGrammarDefinition info = this.registry.getDefinition(scopeName);
            return info != null ? info.getPath() : null;
        }

        public InputStream getInputStream(String scopeName) throws IOException {
            IGrammarDefinition info = this.registry.getDefinition(scopeName);
            return info != null ? info.getInputStream() : null;
        }
    }
}

