/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.widgets;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationMessages;
import org.eclipse.tm4e.languageconfiguration.internal.model.LanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.LanguageConfigurationInfoWidget;

public final class LanguageConfigurationPreferencesWidget
extends LanguageConfigurationInfoWidget {
    @NonNullByDefault(value={})
    private Button toggleOnEnterButton;
    @NonNullByDefault(value={})
    private Button toggleIdentRulesButton;
    @NonNullByDefault(value={})
    private Button toggleBracketAutoClosingButton;
    @NonNullByDefault(value={})
    private Button toggleMatchingPairsButton;
    private ILanguageConfigurationDefinition definition = (ILanguageConfigurationDefinition)NullSafetyHelper.lazyNonNull();
    private ILanguageConfigurationRegistryManager.EditSession manager = (ILanguageConfigurationRegistryManager.EditSession)NullSafetyHelper.lazyNonNull();

    public LanguageConfigurationPreferencesWidget(Composite parent, int style) {
        super(parent, style);
    }

    public void refresh(@Nullable ILanguageConfigurationDefinition definition, ILanguageConfigurationRegistryManager.EditSession manager) {
        LanguageConfiguration langcfg = definition == null ? null : definition.getLanguageConfiguration();
        super.refresh(langcfg);
        if (definition == null) {
            this.toggleOnEnterButton.setEnabled(false);
            this.toggleOnEnterButton.setSelection(false);
            this.toggleIdentRulesButton.setEnabled(false);
            this.toggleIdentRulesButton.setSelection(false);
            this.toggleBracketAutoClosingButton.setEnabled(false);
            this.toggleBracketAutoClosingButton.setSelection(false);
            this.toggleMatchingPairsButton.setEnabled(false);
            this.toggleMatchingPairsButton.setSelection(false);
            return;
        }
        this.toggleOnEnterButton.setSelection(definition.isOnEnterEnabled());
        this.toggleOnEnterButton.setEnabled(langcfg != null && !langcfg.getOnEnterRules().isEmpty());
        this.toggleIdentRulesButton.setSelection(definition.isIndentRulesEnabled());
        this.toggleIdentRulesButton.setEnabled(langcfg != null && langcfg.getIndentationRules() != null);
        this.toggleBracketAutoClosingButton.setSelection(definition.isBracketAutoClosingEnabled());
        this.toggleBracketAutoClosingButton.setEnabled(langcfg != null && !langcfg.getAutoClosingPairs().isEmpty());
        this.toggleMatchingPairsButton.setSelection(definition.isMatchingPairsEnabled());
        this.toggleMatchingPairsButton.setEnabled(langcfg != null && !langcfg.getSurroundingPairs().isEmpty());
        this.definition = definition;
        this.manager = manager;
    }

    @Override
    protected void createOnEnterRulesInfo(Composite parent) {
        super.createOnEnterRulesInfo(parent);
        this.toggleOnEnterButton = new Button(parent, 32);
        this.toggleOnEnterButton.setText(LanguageConfigurationMessages.LanguageConfigurationPreferencesWidget_enableOnEnterActions);
        this.toggleOnEnterButton.setLayoutData((Object)new GridData(768));
        this.toggleOnEnterButton.setEnabled(false);
        this.toggleOnEnterButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.manager.unregisterLanguageConfigurationDefinition(this.definition);
            this.definition.setOnEnterEnabled(this.toggleOnEnterButton.getSelection());
            this.manager.registerLanguageConfigurationDefinition(this.definition);
        }));
    }

    @Override
    protected void createIndentationRulesInfo(Composite parent) {
        super.createIndentationRulesInfo(parent);
        this.toggleIdentRulesButton = new Button(parent, 32);
        this.toggleIdentRulesButton.setText(LanguageConfigurationMessages.LanguageConfigurationPreferencesWidget_enableIndentRules);
        this.toggleIdentRulesButton.setLayoutData((Object)new GridData(768));
        this.toggleIdentRulesButton.setEnabled(false);
        this.toggleIdentRulesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.manager.unregisterLanguageConfigurationDefinition(this.definition);
            this.definition.setIndentRulesEnabled(this.toggleIdentRulesButton.getSelection());
            this.manager.registerLanguageConfigurationDefinition(this.definition);
        }));
    }

    @Override
    protected void createAutoClosingPairsInfo(Composite parent) {
        super.createAutoClosingPairsInfo(parent);
        this.toggleBracketAutoClosingButton = new Button(parent, 32);
        this.toggleBracketAutoClosingButton.setText(LanguageConfigurationMessages.LanguageConfigurationPreferencesWidget_enableAutoClosing);
        this.toggleBracketAutoClosingButton.setLayoutData((Object)new GridData(768));
        this.toggleBracketAutoClosingButton.setEnabled(false);
        this.toggleBracketAutoClosingButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.manager.unregisterLanguageConfigurationDefinition(this.definition);
            this.definition.setBracketAutoClosingEnabled(this.toggleBracketAutoClosingButton.getSelection());
            this.manager.registerLanguageConfigurationDefinition(this.definition);
        }));
    }

    @Override
    protected void createSurroundingPairsInfo(Composite parent) {
        super.createSurroundingPairsInfo(parent);
        this.toggleMatchingPairsButton = new Button(parent, 32);
        this.toggleMatchingPairsButton.setText(LanguageConfigurationMessages.LanguageConfigurationPreferencesWidget_enableMatchingBrackets);
        this.toggleMatchingPairsButton.setLayoutData((Object)new GridData(768));
        this.toggleMatchingPairsButton.setEnabled(false);
        this.toggleMatchingPairsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.manager.unregisterLanguageConfigurationDefinition(this.definition);
            this.definition.setMatchingPairsEnabled(this.toggleMatchingPairsButton.getSelection());
            this.manager.registerLanguageConfigurationDefinition(this.definition);
        }));
    }
}

