/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;

public final class ColorMap {
    private final boolean _isFrozen;
    private int _lastColorId = 0;
    private final List<String> _id2color = new ArrayList<String>();
    private final List<String> _id2colorUnmodifiable = Collections.unmodifiableList(this._id2color);
    private final Map<String, @Nullable Integer> _color2id = new HashMap<String, Integer>();

    public ColorMap() {
        this(null);
    }

    public ColorMap(@Nullable List<String> _colorMap) {
        this._id2color.add("");
        if (_colorMap != null) {
            this._isFrozen = true;
            for (String color : _colorMap) {
                String color_upper = color.toUpperCase();
                this._color2id.put(color_upper, this._id2color.size());
                this._id2color.add(color_upper);
            }
        } else {
            this._isFrozen = false;
        }
    }

    public int getId(@Nullable String color) {
        if (color == null) {
            return 0;
        }
        String color_upper = color.toUpperCase();
        Integer value = this._color2id.get(color_upper);
        if (value != null) {
            return value;
        }
        if (this._isFrozen) {
            throw new TMException("Missing color in frozen color map:" + color_upper);
        }
        value = ++this._lastColorId;
        this._color2id.put(color_upper, value);
        this._id2color.add(color_upper);
        return value;
    }

    public List<String> getColorMap() {
        return this._id2colorUnmodifiable;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (object instanceof ColorMap) {
            void other;
            ColorMap colorMap = (ColorMap)object;
            ColorMap cfr_ignored_0 = (ColorMap)object;
            return this._lastColorId == other._lastColorId && this._color2id.equals(other._color2id);
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 + this._lastColorId) + this._color2id.hashCode();
    }
}

