/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.grm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TransmModeKind implements Enumerator
{
    SIMPLEX(0, "simplex", "simplex"),
    HALF_DUPLEX(1, "half_duplex", "half_duplex"),
    FULL_DUPLEX(2, "full_duplex", "full_duplex");

    public static final int SIMPLEX_VALUE = 0;
    public static final int HALF_DUPLEX_VALUE = 1;
    public static final int FULL_DUPLEX_VALUE = 2;
    private static final TransmModeKind[] VALUES_ARRAY;
    public static final List<TransmModeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TransmModeKind[]{SIMPLEX, HALF_DUPLEX, FULL_DUPLEX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TransmModeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransmModeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransmModeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransmModeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransmModeKind get(int value) {
        switch (value) {
            case 0: {
                return SIMPLEX;
            }
            case 1: {
                return HALF_DUPLEX;
            }
            case 2: {
                return FULL_DUPLEX;
            }
        }
        return null;
    }

    private TransmModeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

