/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.hrm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RomType implements Enumerator
{
    MASKED_ROM(0, "maskedRom", "maskedRom"),
    EPROM(1, "eprom", "eprom"),
    OTP_EPROM(2, "otpEprom", "otpEprom"),
    EEPROM(3, "eeprom", "eeprom"),
    FLASH(4, "flash", "flash"),
    OTHER(5, "other", "other"),
    UNDEF(6, "undef", "undef");

    public static final int MASKED_ROM_VALUE = 0;
    public static final int EPROM_VALUE = 1;
    public static final int OTP_EPROM_VALUE = 2;
    public static final int EEPROM_VALUE = 3;
    public static final int FLASH_VALUE = 4;
    public static final int OTHER_VALUE = 5;
    public static final int UNDEF_VALUE = 6;
    private static final RomType[] VALUES_ARRAY;
    public static final List<RomType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RomType[]{MASKED_ROM, EPROM, OTP_EPROM, EEPROM, FLASH, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RomType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RomType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RomType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RomType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RomType get(int value) {
        switch (value) {
            case 0: {
                return MASKED_ROM;
            }
            case 1: {
                return EPROM;
            }
            case 2: {
                return OTP_EPROM;
            }
            case 3: {
                return EEPROM;
            }
            case 4: {
                return FLASH;
            }
            case 5: {
                return OTHER;
            }
            case 6: {
                return UNDEF;
            }
        }
        return null;
    }

    private RomType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

