/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class ResourceQuery {
    protected final Resource resource;

    public ResourceQuery(Resource resource) {
        this.resource = (Resource)Preconditions.checkNotNull((Object)resource);
    }

    public Collection<URI> getResolvedDependencies() {
        HashSet dependencies = Sets.newHashSet();
        for (EObject root : this.resource.getContents()) {
            dependencies.addAll(new EObjectQuery(root).getResolvedDependencies());
        }
        return dependencies;
    }

    public Collection<URI> getUnresolvedDependencies() {
        HashSet dependencies = Sets.newHashSet();
        for (EObject root : this.resource.getContents()) {
            dependencies.addAll(new EObjectQuery(root).getUnresolvedDependencies());
        }
        return dependencies;
    }

    public boolean isRepresentationsResource() {
        boolean isRepresentationsResource = false;
        URI uri = this.getUri();
        isRepresentationsResource = uri != null && new FileQuery(uri.fileExtension()).isSessionResourceFile();
        boolean bl = isRepresentationsResource = isRepresentationsResource || this.resource instanceof AirdResource;
        if (!isRepresentationsResource && !this.resource.getContents().isEmpty()) {
            isRepresentationsResource = this.resource.getContents().get(0) instanceof DAnalysis;
        }
        return isRepresentationsResource;
    }

    public boolean isAirdOrSrmResource() {
        return this.isSrmResource() || this.isRepresentationsResource();
    }

    public boolean isSrmResource() {
        EList contents = this.resource.getContents();
        return Optional.ofNullable(contents.isEmpty() ? null : (EObject)contents.get(0)).filter(DRepresentation.class::isInstance).isPresent();
    }

    public boolean isModelerResource() {
        URI uri = this.getUri();
        if (uri != null) {
            return new FileQuery(uri.fileExtension()).isVSMFile();
        }
        return false;
    }

    private URI getUri() {
        URI uri = null;
        try {
            uri = this.resource.getURI();
        }
        catch (IllegalStateException illegalStateException) {}
        return uri;
    }
}

