"use strict";
/********************************************************************************
 * Copyright (c) 2021 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 *******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ignoreGCCFlagsCommandHandler = exports.GCC_FLAGS = exports.IGNORE_GCC_FLAGS_COMMAND = void 0;
const clangd_contexts_1 = require("@eclipse-cdt-cloud/clangd-contexts");
const vscode = require("vscode");
const util_1 = require("./util");
exports.IGNORE_GCC_FLAGS_COMMAND = 'cdtcloud-clangd-contexts.ignore.gccFlags';
exports.GCC_FLAGS = ['-fstack-usage'];
async function ignoreGCCFlagsCommandHandler(args) {
    var _a;
    // As the VS Code workspace may have multiple roots, we support any number of URI args
    let paths = (_a = getPaths(args)) === null || _a === void 0 ? void 0 : _a.map(uri => uri.fsPath);
    if (!paths && vscode.workspace.workspaceFolders) {
        paths = vscode.workspace.workspaceFolders.map(folder => folder.uri).filter(isFileUri).map(uri => uri.fsPath);
    }
    if (!paths || (paths === null || paths === void 0 ? void 0 : paths.length) === 0) {
        return;
    }
    paths.map(path => util_1.findMatchingFiles(path, file => file.endsWith(clangd_contexts_1.CONFIG_FILE_NAME)))
        .reduce((flattened, array) => flattened.concat(array), [])
        .forEach(configFile => clangd_contexts_1.setCompileFlags(configFile, undefined, exports.GCC_FLAGS));
    await util_1.restartClangdLanguageServer();
}
exports.ignoreGCCFlagsCommandHandler = ignoreGCCFlagsCommandHandler;
function getPaths(args) {
    if (args.length > 0 && args.some(isFileUri)) {
        return args.filter(isFileUri);
    }
    return undefined;
}
function isFileUri(object) {
    return object instanceof vscode.Uri && object.scheme === 'file';
}
//# sourceMappingURL=ignore-gcc-flags-command.js.map