/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service.xml;

import org.eclipse.epp.internal.mpc.core.model.Catalog;
import org.eclipse.epp.internal.mpc.core.model.Catalogs;
import org.eclipse.epp.internal.mpc.core.model.News;
import org.eclipse.epp.internal.mpc.core.service.xml.CatalogBrandingContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.NewsContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.UnmarshalContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CatalogContentHandler
extends UnmarshalContentHandler {
    private static final String NS_URI = "";
    private Catalog model;

    @Override
    public void startElement(String uri, String localName, Attributes attributes) {
        if (localName.equals("catalog")) {
            this.model = new Catalog();
            this.model.setId(attributes.getValue(NS_URI, "id"));
            this.model.setName(attributes.getValue(NS_URI, "title"));
            this.model.setUrl(this.toUrlString(attributes.getValue(NS_URI, "url")));
            this.model.setSelfContained("1".equals(attributes.getValue(NS_URI, "selfContained")));
            this.model.setImageUrl(this.toUrlString(attributes.getValue(NS_URI, "icon")));
        } else if (localName.equals("dependenciesRepository")) {
            this.capturingContent = true;
        } else if (localName.equals("description")) {
            this.capturingContent = true;
        } else if (localName.equals("wizard")) {
            CatalogBrandingContentHandler childHandler = new CatalogBrandingContentHandler();
            childHandler.setParentModel(this.model);
            childHandler.setParentHandler(this);
            childHandler.setUnmarshaller(this.getUnmarshaller());
            this.getUnmarshaller().setCurrentHandler(childHandler);
            childHandler.startElement(uri, localName, attributes);
        } else if (localName.equals("news")) {
            NewsContentHandler childHandler = new NewsContentHandler();
            childHandler.setParentModel(this.model);
            childHandler.setParentHandler(this);
            childHandler.setUnmarshaller(this.getUnmarshaller());
            this.getUnmarshaller().setCurrentHandler(childHandler);
            childHandler.startElement(uri, localName, attributes);
        }
    }

    @Override
    public boolean endElement(String uri, String localName) throws SAXException {
        if (localName.equals("catalog")) {
            if (this.parentModel instanceof Catalogs) {
                ((Catalogs)this.parentModel).getCatalogs().add(this.model);
            }
            this.getUnmarshaller().setModel(this.model);
            this.model = null;
            this.getUnmarshaller().setCurrentHandler(this.parentHandler);
            if (this.parentHandler != null) {
                this.parentHandler.endElement(uri, localName);
            }
            return true;
        }
        if (localName.equals("dependenciesRepository")) {
            if (this.content != null) {
                this.model.setDependencyRepository(this.toUrlString(this.content.toString()));
                this.content = null;
            }
            this.capturingContent = false;
        } else if (localName.equals("description")) {
            if (this.content != null) {
                this.model.setDescription(this.content.toString());
                this.content = null;
            }
            this.capturingContent = false;
        } else if (localName.equals("news")) {
            News news = (News)this.getUnmarshaller().getModel();
            this.getUnmarshaller().setModel(null);
            this.model.setNews(news);
        }
        return false;
    }
}

