/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class IconFinder {
    private static final String LEAF = "_leaf";
    private static final String CLOSED = "_closed";
    private static final String OPEN = "_open";
    private static final String ALT = "_alt";
    private static final String EXT_PT = "org.eclipse.help.toc";
    private static final String TOC_ICON_ELEMENT = "tocIcon";
    private static final String TOC_ICON_ID = "id";
    private static final String OPEN_ICON_PATH = "openIcon";
    private static final String CLOSED_ICON_PATH = "closedIcon";
    private static final String LEAF_ICON_PATH = "leafIcon";
    private static final String ICON_ALT_TEXT = "altText";
    private static final String PATH_SEPARATOR = "/";
    private static boolean iconsInitialized = false;
    public static int TYPEICON_OPEN = 0;
    public static int TYPEICON_CLOSED = 1;
    public static int TYPEICON_LEAF = 2;
    private static Map<String, String> IconPathMap = null;

    private static void addIconPath(String IconKey, String IconPath) {
        if (IconPathMap == null) {
            IconPathMap = new HashMap<String, String>();
            IconPathMap = new TreeMap<String, String>();
        }
        IconPathMap.put(IconKey, IconPath);
    }

    private static String getIconPath(String IconKey) {
        return IconFinder.getEntry(IconKey);
    }

    private static String getIconAltText(String IconKey) {
        return IconFinder.getEntry(IconKey);
    }

    private static String getEntry(String IconKey) {
        if (IconPathMap == null) {
            return null;
        }
        String key = IconPathMap.get(IconKey);
        return key;
    }

    private static void setIconImagePath(String bundleId, String path, String key) {
        Object iconPath = IconFinder.getIconPath(key);
        if (iconPath == null) {
            iconPath = bundleId + PATH_SEPARATOR + path;
            IconFinder.addIconPath(key, (String)iconPath);
        }
    }

    private static void setIconAltText(String value, String key) {
        IconFinder.addIconPath(key, value);
    }

    public static String getImagePathFromId(String iconId, int type) {
        if (iconId == null) {
            return null;
        }
        IconFinder.initializeTocIcons();
        String result = IconFinder.lookupImagePath(iconId + (switch (type) {
            case 0 -> OPEN;
            case 1 -> CLOSED;
            case 2 -> LEAF;
            default -> OPEN;
        }));
        if (result != null) {
            return result;
        }
        return IconFinder.lookupImagePath(iconId + OPEN);
    }

    public static String getIconAltFromId(String iconId) {
        if (iconId == null) {
            return null;
        }
        IconFinder.initializeTocIcons();
        return IconFinder.getIconAltText(iconId + ALT);
    }

    public static boolean isIconDefined(String icon) {
        if (icon == null || icon.length() == 0) {
            return false;
        }
        String result = IconFinder.getImagePathFromId(icon, TYPEICON_OPEN);
        return result != null;
    }

    private static String lookupImagePath(String name) {
        return IconFinder.getIconPath(name);
    }

    private static void initializeTocIcons() {
        IExtension[] extensionsFound;
        if (iconsInitialized) {
            return;
        }
        iconsInitialized = true;
        IExtension[] iExtensionArray = extensionsFound = Platform.getExtensionRegistry().getExtensionPoint(EXT_PT).getExtensions();
        int n = extensionsFound.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension element = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = element.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement iconElem = iConfigurationElementArray[n4];
                if (iconElem.getName().equals(TOC_ICON_ELEMENT)) {
                    String[] attrs = iconElem.getAttributeNames();
                    String contributorID = iconElem.getContributor().getName();
                    String[] stringArray = attrs;
                    int n5 = attrs.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String attr = stringArray[n6];
                        if (attr.equals(OPEN_ICON_PATH)) {
                            IconFinder.setIconImagePath(contributorID, iconElem.getAttribute(OPEN_ICON_PATH), iconElem.getAttribute(TOC_ICON_ID) + OPEN);
                        }
                        if (attr.equals(CLOSED_ICON_PATH)) {
                            IconFinder.setIconImagePath(contributorID, iconElem.getAttribute(CLOSED_ICON_PATH), iconElem.getAttribute(TOC_ICON_ID) + CLOSED);
                        }
                        if (attr.equals(LEAF_ICON_PATH)) {
                            IconFinder.setIconImagePath(contributorID, iconElem.getAttribute(LEAF_ICON_PATH), iconElem.getAttribute(TOC_ICON_ID) + LEAF);
                        }
                        if (attr.equals(ICON_ALT_TEXT)) {
                            IconFinder.setIconAltText(iconElem.getAttribute(ICON_ALT_TEXT), iconElem.getAttribute(TOC_ICON_ID) + ALT);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }
}

