/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCastExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;

public class CPPASTCastExpression
extends ASTNode
implements ICPPASTCastExpression,
IASTAmbiguityParent {
    private int fOperator;
    private ICPPASTExpression fOperand;
    private IASTTypeId fTypeId;
    private ICPPEvaluation fEvaluation;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTCastExpression() {
    }

    public CPPASTCastExpression(int operator, IASTTypeId typeId, IASTExpression operand) {
        this.fOperator = operator;
        this.setOperand(operand);
        this.setTypeId(typeId);
    }

    @Override
    public CPPASTCastExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCastExpression copy(IASTNode.CopyStyle style) {
        CPPASTCastExpression copy = new CPPASTCastExpression();
        copy.setOperator(this.getOperator());
        copy.setTypeId(this.fTypeId == null ? null : this.fTypeId.copy(style));
        IASTExpression operand = this.getOperand();
        copy.setOperand(operand == null ? null : operand.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.fTypeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.fTypeId;
    }

    @Override
    public int getOperator() {
        return this.fOperator;
    }

    @Override
    public void setOperator(int operator) {
        this.assertNotFrozen();
        this.fOperator = operator;
    }

    @Override
    public IASTExpression getOperand() {
        return this.fOperand;
    }

    @Override
    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.fOperand = (ICPPASTExpression)expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fTypeId != null && !this.fTypeId.accept(action)) {
            return false;
        }
        IASTExpression op = this.getOperand();
        if (op != null && !op.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTCastExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fOperand) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fOperand = (ICPPASTExpression)other;
        }
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.computeEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        if (this.fOperand == null) {
            return EvalFixed.INCOMPLETE;
        }
        IType type = CPPVisitor.createType(this.getTypeId());
        if (type == null || type instanceof IProblemType) {
            return EvalFixed.INCOMPLETE;
        }
        return new EvalTypeId(type, this, false, this.fOperand.getEvaluation());
    }

    @Override
    public IType getExpressionType() {
        return CPPEvaluation.getType(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return CPPEvaluation.getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }
}

