"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.arePositionsEqual = arePositionsEqual;
exports.translatePosition = translatePosition;
exports.isBefore = isBefore;
exports.isBeforeOrEqual = isBeforeOrEqual;
exports.isAfter = isAfter;
exports.comparePosition = comparePosition;
function arePositionsEqual(a, b) {
    return a.line === b.line && a.character === b.character;
}
function translatePosition(pos, change) {
    return {
        line: pos.line + (change.lineDelta ?? 0),
        character: pos.character + (change.characterDelta ?? 0),
    };
}
function isBefore(pos, other) {
    if (pos.line < other.line) {
        return true;
    }
    if (other.line < pos.line) {
        return false;
    }
    return pos.character < other.character;
}
function isBeforeOrEqual(pos, other) {
    if (pos.line < other.line) {
        return true;
    }
    if (other.line < pos.line) {
        return false;
    }
    return pos.character <= other.character;
}
function isAfter(pos, other) {
    return !isBeforeOrEqual(pos, other);
}
function comparePosition(a, b) {
    if (a.line < b.line) {
        return -1;
    }
    else if (a.line > b.line) {
        return 1;
    }
    else {
        // equal line
        if (a.character < b.character) {
            return -1;
        }
        else if (a.character > b.character) {
            return 1;
        }
        else {
            // equal line and character
            return 0;
        }
    }
}
//# sourceMappingURL=position.js.map