/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;

public class ResourceDependencyRegister {
    protected static Map GLOBAL_DEPENDENCIES = new HashMap();
    private static String RESOURCE_DEPENDENCY_TYPE = "ResourceDependencyAdapter";
    protected Map localDependencies = new HashMap();

    public static void registerDependency(URI targetURI, URI dependentURI) {
        if (targetURI != null && dependentURI != null) {
            GLOBAL_DEPENDENCIES.put(dependentURI, targetURI);
        }
    }

    public ResourceDependencyRegister(ResourceSet aResourceSet) {
        this.initialize(aResourceSet);
    }

    ResourceDependencyRegister() {
    }

    protected void initialize(ResourceSet aResourceSet) {
        if (aResourceSet == null) {
            throw new NullPointerException("The ResourceSet cannot be null.");
        }
        this.initializeLocalDependencies(aResourceSet);
        this.setupDependencyAdapters(aResourceSet);
        this.setupResourceSetListener(aResourceSet);
    }

    protected void setupResourceSetListener(ResourceSet aResourceSet) {
        aResourceSet.eAdapters().add((Object)new ResourceSetListener());
    }

    protected void setupDependencyAdapters(ResourceSet aResourceSet) {
        if (!aResourceSet.getResources().isEmpty()) {
            for (Map.Entry entry : this.localDependencies.entrySet()) {
                URI dependentURI = (URI)entry.getKey();
                URI targetURI = (URI)entry.getValue();
                this.setupDependencyAdapter(aResourceSet, dependentURI, targetURI);
            }
        }
    }

    protected void setupDependencyAdapter(ResourceSet aResourceSet, URI dependentURI, URI targetURI) {
        Resource dependent = aResourceSet.getResource(dependentURI, false);
        if (dependent != null) {
            this.setupDependencyAdapter(dependent, targetURI, aResourceSet);
        }
    }

    protected void setupDependencyAdapter(Resource dependent, URI targetURI, ResourceSet aResourceSet) {
        Resource target = aResourceSet.getResource(targetURI, false);
        if (target == null) {
            target = aResourceSet.createResource(targetURI);
        }
        target.eAdapters().add((Object)new ResourceDependencyAdapter(dependent));
    }

    protected void initializeLocalDependencies(ResourceSet aResourceSet) {
        URIConverter converter = aResourceSet.getURIConverter();
        this.initializeLocalDependencies(converter);
    }

    protected void initializeLocalDependencies(URIConverter aConverter) {
        Iterator it = GLOBAL_DEPENDENCIES.entrySet().iterator();
        HashMap resolved = new HashMap();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            URI key = (URI)entry.getKey();
            URI value = (URI)entry.getValue();
            key = this.normalize(key, aConverter, resolved);
            value = this.normalize(value, aConverter, resolved);
            this.localDependencies.put(key, value);
        }
    }

    protected URI normalize(URI relativeURI, URIConverter converter, Map resolved) {
        URI result = (URI)resolved.get(relativeURI);
        if (result == null) {
            result = converter.normalize(relativeURI);
            resolved.put(relativeURI, result);
        }
        return result;
    }

    protected void proccessAddedResource(ResourceSet set, Resource resource) {
        URI targetURI = (URI)this.localDependencies.get(resource.getURI());
        if (targetURI != null) {
            this.setupDependencyAdapter(resource, targetURI, set);
        }
    }

    class ResourceDependencyAdapter
    extends AdapterImpl {
        Resource dependentResource;

        ResourceDependencyAdapter(Resource aDependentResource) {
            this.dependentResource = aDependentResource;
            this.dependentResource.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(Object type) {
            return RESOURCE_DEPENDENCY_TYPE.equals(type);
        }

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(null)) {
                case 4: {
                    if (msg.getNotifier() == this.dependentResource || !msg.getOldBooleanValue() || msg.getNewBooleanValue()) break;
                    this.dependentResource.unload();
                    break;
                }
                case 0: {
                    if (msg.getOldValue() == null || msg.getNewValue() != null) break;
                    if (msg.getNotifier() == this.dependentResource) {
                        this.getTarget().eAdapters().remove((Object)this);
                        break;
                    }
                    ResourceSet set = this.dependentResource.getResourceSet();
                    if (set == null) break;
                    set.getResources().remove((Object)this.dependentResource);
                }
            }
        }
    }

    class ResourceSetListener
    extends AdapterImpl {
        ResourceSetListener() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 3) {
                ResourceDependencyRegister.this.proccessAddedResource((ResourceSet)msg.getNotifier(), (Resource)msg.getNewValue());
            }
        }
    }
}

