/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import java.util.ArrayList;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.profile.core.data.ProfilerCallTrace;
import org.eclipse.php.profile.core.data.ProfilerCallTraceLayer;
import org.eclipse.php.profile.core.engine.IProfileSessionListener;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.actions.ExecutionFlowActionGroup;
import org.eclipse.php.profile.ui.views.AbstractProfilerFunctionsView;
import org.eclipse.php.profile.ui.views.ExecutionFlowContentProvider;
import org.eclipse.php.profile.ui.views.ExecutionFlowLabelProvider;
import org.eclipse.php.profile.ui.views.ExecutionFlowTreeElement;
import org.eclipse.php.profile.ui.views.TreeElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class ExecutionFlowView
extends AbstractProfilerFunctionsView
implements IDoubleClickListener,
IMenuListener,
IProfileSessionListener {
    private TreeViewer fViewer;
    private String[] fColumnHeaders = new String[]{PHPProfileUIMessages.getString("ExecutionFlowView_0"), PHPProfileUIMessages.getString("ExecutionFlowView_1"), PHPProfileUIMessages.getString("ExecutionFlowView_2"), PHPProfileUIMessages.getString("ExecutionFlowView_3")};
    private int[] fColumnWidths = new int[]{300, 200, 150, 150};
    private int[] fNumericColumns = new int[]{2, 3};
    private ExecutionFlowActionGroup fActionSet;
    private Tree fTree;
    private Menu fContextMenu;
    private ProfilerDB fProfilerDB;

    public void createPartControl(Composite parent) {
        this.fTree = new Tree(parent, 66306);
        this.fTree.setLinesVisible(true);
        this.fTree.setHeaderVisible(true);
        int i = 0;
        while (i < this.fColumnHeaders.length) {
            TreeColumn tableColumn = new TreeColumn(this.fTree, 16384, i);
            tableColumn.setText(this.fColumnHeaders[i]);
            tableColumn.setWidth(this.fColumnWidths[i]);
            int c = 0;
            while (c < this.fNumericColumns.length) {
                if (this.fNumericColumns[c] == i) {
                    tableColumn.setAlignment(131072);
                    break;
                }
                ++c;
            }
            ++i;
        }
        this.fViewer = new TreeViewer(this.fTree);
        this.fViewer.setContentProvider((IContentProvider)new ExecutionFlowContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ExecutionFlowLabelProvider());
        this.fViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.fActionSet = new ExecutionFlowActionGroup(this);
        this.fActionSet.fillActionBars(this.getViewSite().getActionBars());
        this.hookContextMenu();
        ProfileSessionsManager.addProfileSessionListener((IProfileSessionListener)this);
        this.setInput(ProfileSessionsManager.getCurrent());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.execution_flow_view");
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.fViewer.removeDoubleClickListener((IDoubleClickListener)this);
        }
        ProfileSessionsManager.removeProfileSessionListener((IProfileSessionListener)this);
        super.dispose();
    }

    public void setFocus() {
    }

    @Override
    public ProfilerDB getInput() {
        return this.fProfilerDB;
    }

    @Override
    public void setInput(ProfilerDB profilerDB) {
        if (this.fViewer == null || this.fViewer.getContentProvider() == null) {
            return;
        }
        if (this.fProfilerDB != profilerDB) {
            if (profilerDB != null) {
                ProfilerCallTrace callTrace = profilerDB.getCallTrace();
                if (callTrace != null) {
                    ProfilerCallTraceLayer[] layers = callTrace.getLayers();
                    ExecutionFlowTreeElement current = null;
                    ExecutionFlowTreeElement root = new ExecutionFlowTreeElement();
                    ArrayList<ExecutionFlowTreeElement> elements = new ArrayList<ExecutionFlowTreeElement>();
                    int i = 0;
                    while (i < layers.length) {
                        if (layers[i].getType() == 1) {
                            ExecutionFlowTreeElement element = new ExecutionFlowTreeElement(i);
                            element.setData(profilerDB.getFunctionData(layers[i].getCalledID()));
                            element.setLayer(layers[i]);
                            if (current != null) {
                                current.addChild(element);
                                element.setParent(current);
                            }
                            current = element;
                            elements.add(element);
                        } else if (current != null) {
                            ProfilerCallTraceLayer currentLayer = current.getLayer();
                            currentLayer.setDuration((long)layers[i].getTimestampSeconds(), (long)layers[i].getTimestampMicroseconds());
                            current.setDuration(currentLayer.getDurationInMilli());
                            if (current.getParent() != null) {
                                current = (ExecutionFlowTreeElement)current.getParent();
                            }
                        }
                        ++i;
                    }
                    if (current != null) {
                        double totalDuration = profilerDB.getGlobalData().getGlobalTimeInMilli();
                        int i2 = 0;
                        while (i2 < elements.size()) {
                            ExecutionFlowTreeElement element = (ExecutionFlowTreeElement)elements.get(i2);
                            element.setTimePercentage(element.getDuration() / totalDuration * 100.0);
                            ++i2;
                        }
                        root.addChild(current);
                        current.setParent(root);
                        this.fViewer.setInput((Object)root);
                    }
                }
            } else {
                this.fViewer.setInput(null);
            }
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
            this.fProfilerDB = profilerDB;
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.fActionSet.viewFunctionCallInEditor(event.getSelection());
    }

    @Override
    public TreeViewer getViewer() {
        return this.fViewer;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        TreeElement element = (TreeElement)event.getElement();
        element.setExpanded(false);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        TreeElement element = (TreeElement)event.getElement();
        element.setExpanded(true);
    }

    public void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fTree);
        this.fTree.setMenu(this.fContextMenu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.fActionSet.fillContextMenu(manager);
    }

    public void currentSessionChanged(final ProfilerDB current) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionFlowView.this.setInput(current);
            }
        });
    }

    public void profileSessionAdded(ProfilerDB db) {
    }

    public void profileSessionRemoved(ProfilerDB db) {
    }
}

