/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.launching.AbstractPHPLaunchConfigurationDebuggerTab;
import org.eclipse.php.internal.debug.ui.launching.IDebuggerLaunchSettingsSection;
import org.eclipse.php.internal.debug.ui.launching.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AbstractDebugExeLaunchSettingsSection
implements IDebuggerLaunchSettingsSection {
    protected AbstractPHPLaunchConfigurationDebuggerTab.WidgetListener widgetListener;
    protected Group breakpointGroup;
    protected Button breakOnFirstLine;
    private ILaunchConfiguration configuration;

    @Override
    public void createSection(Composite parent, AbstractPHPLaunchConfigurationDebuggerTab.WidgetListener widgetListener) {
        this.widgetListener = widgetListener;
        this.createBreakpointGroup(parent);
    }

    @Override
    public void initialize(ILaunchConfiguration configuration) {
        this.configuration = configuration;
        try {
            if (this.breakpointGroup != null) {
                this.breakOnFirstLine.setSelection(configuration.getAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine()));
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.breakpointGroup != null) {
            configuration.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        }
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.configuration = configuration;
    }

    @Override
    public AbstractPHPLaunchConfigurationDebuggerTab.StatusMessage isValid(ILaunchConfiguration configuration) {
        return new AbstractPHPLaunchConfigurationDebuggerTab.StatusMessage(0, "");
    }

    protected void createBreakpointGroup(Composite parent) {
        this.breakpointGroup = new Group(parent, 0);
        this.breakpointGroup.setText(Messages.AbstractDebugExeLaunchSettingsSection_Breakpoint);
        this.breakpointGroup.setLayout((Layout)new GridLayout(1, false));
        this.breakpointGroup.setLayoutData((Object)new GridData(768));
        this.breakOnFirstLine = SWTFactory.createCheckButton((Composite)this.breakpointGroup, (String)Messages.AbstractDebugExeLaunchSettingsSection_Break_at_first_line, null, (boolean)false, (int)1);
        this.breakOnFirstLine.addSelectionListener((SelectionListener)this.widgetListener);
    }

    protected ILaunchConfiguration getConfiguration() {
        return this.configuration;
    }
}

