/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.sorters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;

public class CommonSorterDescriptorManager {
    private static final CommonSorterDescriptorManager INSTANCE = new CommonSorterDescriptorManager();
    private static final CommonSorterDescriptor[] NO_SORTER_DESCRIPTORS = new CommonSorterDescriptor[0];
    private final Map<INavigatorContentDescriptor, Set<CommonSorterDescriptor>> sortersMap = new HashMap<INavigatorContentDescriptor, Set<CommonSorterDescriptor>>();

    public static CommonSorterDescriptorManager getInstance() {
        return INSTANCE;
    }

    private CommonSorterDescriptorManager() {
        new CommonSorterDescriptorRegistry().readRegistry();
    }

    public CommonSorterDescriptor[] findApplicableSorters(NavigatorContentService contentService, Object aParent) {
        NavigatorContentDescriptor sourceOfContribution = contentService.getSourceOfContribution(aParent);
        return this.findApplicableSorters(contentService, sourceOfContribution, aParent);
    }

    public CommonSorterDescriptor[] findApplicableSorters(NavigatorContentService aContentService, INavigatorContentDescriptor theSource, Object aParent) {
        ArrayList<CommonSorterDescriptor> applicableSorters = new ArrayList<CommonSorterDescriptor>();
        Set<CommonSorterDescriptor> sorters = this.getCommonSorters(theSource);
        for (CommonSorterDescriptor descriptor : sorters) {
            if (!descriptor.isEnabledForParent(aParent)) continue;
            applicableSorters.add(descriptor);
        }
        if (applicableSorters.isEmpty()) {
            return NO_SORTER_DESCRIPTORS;
        }
        return applicableSorters.toArray(new CommonSorterDescriptor[applicableSorters.size()]);
    }

    public CommonSorterDescriptor[] findApplicableSorters(INavigatorContentDescriptor theSource) {
        Set<CommonSorterDescriptor> sorters = this.getCommonSorters(theSource);
        if (sorters.isEmpty()) {
            return NO_SORTER_DESCRIPTORS;
        }
        return sorters.toArray(new CommonSorterDescriptor[sorters.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<CommonSorterDescriptor> getCommonSorters(INavigatorContentDescriptor contentDescriptor) {
        Set<CommonSorterDescriptor> descriptors = null;
        Map<INavigatorContentDescriptor, Set<CommonSorterDescriptor>> map = this.sortersMap;
        synchronized (map) {
            descriptors = this.sortersMap.get(contentDescriptor);
            if (descriptors == null) {
                descriptors = new HashSet<CommonSorterDescriptor>();
                this.sortersMap.put(contentDescriptor, descriptors);
            }
        }
        return descriptors;
    }

    private class CommonSorterDescriptorRegistry
    extends NavigatorContentRegistryReader {
        private CommonSorterDescriptorRegistry() {
        }

        @Override
        protected boolean readElement(IConfigurationElement element) {
            if ("navigatorContent".equals(element.getName())) {
                String id = element.getAttribute("id");
                if (id != null) {
                    NavigatorContentDescriptor contentDescriptor = this.CONTENT_DESCRIPTOR_MANAGER.getContentDescriptor(id);
                    if (contentDescriptor != null) {
                        IConfigurationElement[] children = element.getChildren("commonSorter");
                        if (children.length > 0) {
                            Set<CommonSorterDescriptor> localSorters = CommonSorterDescriptorManager.this.getCommonSorters(contentDescriptor);
                            IConfigurationElement[] iConfigurationElementArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                                localSorters.add(new CommonSorterDescriptor(configurationElement));
                                ++n2;
                            }
                            return true;
                        }
                    } else {
                        NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.CommonSorterDescriptorManager_A_navigatorContent_extension_does_n_, (Object[])new Object[]{id, element.getDeclaringExtension().getContributor().getName()}), null);
                    }
                } else {
                    NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.CommonSorterDescriptorManager_A_navigatorContent_extension_in_0_, (Object)element.getNamespaceIdentifier()), null);
                }
            }
            return super.readElement(element);
        }
    }
}

