/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import java.text.MessageFormat;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

public class HistoryAction
extends Action {
    private TypeHierarchyViewPart fViewPart;
    private IModelElement fElement;

    public HistoryAction(TypeHierarchyViewPart viewPart, IModelElement element) {
        super("", 8);
        this.fViewPart = viewPart;
        this.fElement = element;
        String elementName = ScriptElementLabels.getDefault().getElementLabel(element, ScriptElementLabels.ALL_POST_QUALIFIED | ScriptElementLabels.ALL_DEFAULT);
        this.setText(elementName);
        this.setImageDescriptor(this.getImageDescriptor(element));
        this.setDescription(MessageFormat.format(TypeHierarchyMessages.HistoryAction_description, elementName));
        this.setToolTipText(MessageFormat.format(TypeHierarchyMessages.HistoryAction_tooltip, elementName));
    }

    private ImageDescriptor getImageDescriptor(IModelElement elem) {
        ScriptElementImageProvider imageProvider = new ScriptElementImageProvider();
        ImageDescriptor desc = imageProvider.getBaseImageDescriptor(elem, 0);
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fViewPart.gotoHistoryEntry(this.fElement);
    }
}

