/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.dltk.internal.ui.callhierarchy.HistoryAction;
import org.eclipse.dltk.internal.ui.callhierarchy.HistoryListAction;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private CallHierarchyViewPart fView;
    private Menu fMenu;

    public HistoryDropDownAction(CallHierarchyViewPart view) {
        this.fView = view;
        this.fMenu = null;
        this.setToolTipText(CallHierarchyMessages.HistoryDropDownAction_tooltip);
        DLTKPluginImages.setLocalImageDescriptors((IAction)this, "history_list.png");
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
        this.setMenuCreator(this);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        IMethod[] elements = this.fView.getHistoryEntries();
        this.addEntries(this.fMenu, elements);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new HistoryListAction(this.fView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fView));
        return this.fMenu;
    }

    public void dispose() {
        this.fView = null;
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private boolean addEntries(Menu menu, IMethod[] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        int i = 0;
        while (i < min) {
            HistoryAction action = new HistoryAction(this.fView, elements[i]);
            action.setChecked(elements[i].equals(this.fView.getMethod()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
            ++i;
        }
        return checked;
    }

    public void run() {
        new HistoryListAction(this.fView).run();
    }

    private static class ClearHistoryAction
    extends Action {
        private CallHierarchyViewPart fView;

        public ClearHistoryAction(CallHierarchyViewPart view) {
            super(CallHierarchyMessages.HistoryDropDownAction_clearhistory_label);
            this.fView = view;
        }

        public void run() {
            this.fView.setHistoryEntries(new IMethod[0]);
            this.fView.setMethod(null);
        }
    }
}

