/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.collection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.php.composer.api.entities.AbstractJsonObject;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.api.objects.Script;

public class Scripts
extends AbstractJsonObject<Script>
implements Iterable<Script> {
    private transient PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Scripts.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    };

    public static String[] getEvents() {
        return new String[]{"pre-install-cmd", "post-install-cmd", "pre-update-cmd", "post-update-cmd", "pre-package-install", "post-package-install", "pre-package-update", "post-package-update", "pre-package-uninstall", "post-package-uninstall"};
    }

    public Scripts() {
    }

    public Scripts(String json) throws ParseException {
        this.fromJson(json);
    }

    @Override
    protected void doParse(Object obj) {
        this.clear();
        if (obj instanceof LinkedHashMap) {
            LinkedHashMap json = (LinkedHashMap)obj;
            for (Map.Entry entry : json.entrySet()) {
                Script script = new Script();
                script.setScript((String)entry.getKey());
                if (entry.getValue() instanceof LinkedList) {
                    for (Object handler : (LinkedList)entry.getValue()) {
                        script.add(new Script.HandlerValue((String)handler));
                    }
                } else {
                    script.add(new Script.HandlerValue((String)entry.getValue()));
                }
                this.add(script);
            }
        }
    }

    @Override
    protected Object buildJson() {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        for (Script script : this) {
            Object value = "";
            if (script.size() > 1) {
                value = script.getHandlersJsonValue();
            } else if (script.size() == 1) {
                value = script.getFirst().getAsString();
            }
            out.put(script.getScript(), value);
        }
        return out;
    }

    public void add(Script script) {
        if (this.has(script)) {
            ((Script)this.get(script.getScript())).addHandlers(script);
        } else {
            script.addPropertyChangeListener(this.listener);
            this.set(script.getScript(), script);
        }
    }

    public void remove(Script script) {
        script.removePropertyChangeListener(this.listener);
        super.remove(script.getScript());
    }

    public Collection<Script> getScripts() {
        return this.properties.values();
    }

    @Override
    public Iterator<Script> iterator() {
        return this.properties.values().iterator();
    }

    public Script getFirst() {
        if (this.properties.values().iterator().hasNext()) {
            return (Script)this.properties.values().iterator().next();
        }
        return null;
    }

    @Override
    public int size() {
        return this.properties.keySet().size();
    }

    @Override
    public boolean has(String script) {
        return this.properties.containsKey(script);
    }

    public boolean has(Script script) {
        return this.has(script.getScript());
    }

    public boolean hasHandler(String handler) {
        throw new UnsupportedOperationException();
    }

    public Script getScriptForHandler(String handler) {
        for (Script script : this.properties.values()) {
            if (!script.has(handler)) continue;
            return script;
        }
        return null;
    }
}

