/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.openon;

import java.util.ResourceBundle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.ui.internal.IExtendedSimpleEditor;
import org.eclipse.wst.sse.ui.internal.openon.IOpenOn;
import org.eclipse.wst.sse.ui.internal.openon.OpenOnProvider;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;

public class OpenOnAction
extends TextEditorAction {
    public OpenOnAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        BusyIndicator.showWhile((Display)this.getTextEditor().getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ISelection sel;
                ITextEditor editor = OpenOnAction.this.getTextEditor();
                int offset = -1;
                ISourceEditingTextTools textTools = (ISourceEditingTextTools)OpenOnAction.this.getTextEditor().getAdapter(ISourceEditingTextTools.class);
                if (textTools != null) {
                    offset = textTools.getCaretOffset();
                } else if (editor instanceof IExtendedSimpleEditor) {
                    offset = ((IExtendedSimpleEditor)editor).getCaretPosition();
                } else if (editor.getSelectionProvider() != null && (sel = editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
                    offset = ((ITextSelection)sel).getOffset();
                }
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                IOpenOn openOn = OpenOnProvider.getInstance().getOpenOn(document, offset);
                if (openOn != null) {
                    openOn.openOn(document, (IRegion)new Region(offset, 0));
                }
            }
        });
    }
}

