/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.OuterProjectFileFilter;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class FileSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private final Match[] EMPTY_ARR = new Match[0];
    private final FileSearchQuery fQuery;
    private static MatchFilter INNERMOST_PROJECT = new OuterProjectFileFilter();
    private static MatchFilter[] ALL_MATCH_FILTERS = new MatchFilter[]{INNERMOST_PROJECT};
    private static final String SETTINGS_LAST_USED_FILTERS = "filters_last_used";

    public FileSearchResult(FileSearchQuery job) {
        this.fQuery = job;
        this.setActiveMatchFilters(FileSearchResult.getLastUsedFilters());
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return SearchPluginImages.DESC_OBJ_TSEARCH_DPDN;
    }

    @Override
    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    @Override
    public String getTooltip() {
        return this.getLabel();
    }

    @Override
    public MatchFilter[] getAllMatchFilters() {
        return ALL_MATCH_FILTERS;
    }

    @Override
    public synchronized void setActiveMatchFilters(MatchFilter[] filters) {
        super.setActiveMatchFilters(filters);
        FileSearchResult.setLastUsedFilters(filters);
    }

    @Override
    public synchronized MatchFilter[] getActiveMatchFilters() {
        return super.getActiveMatchFilters();
    }

    public static MatchFilter[] getLastUsedFilters() {
        String string = SearchPlugin.getDefault().getDialogSettings().get(SETTINGS_LAST_USED_FILTERS);
        if (string != null) {
            return FileSearchResult.decodeFiltersString(string);
        }
        return new MatchFilter[0];
    }

    public static void setLastUsedFilters(MatchFilter[] filters) {
        String encoded = FileSearchResult.encodeFilters(filters);
        SearchPlugin.getDefault().getDialogSettings().put(SETTINGS_LAST_USED_FILTERS, encoded);
    }

    private static String encodeFilters(MatchFilter[] enabledFilters) {
        StringBuilder buf = new StringBuilder();
        MatchFilter[] matchFilterArray = enabledFilters;
        int n = enabledFilters.length;
        int n2 = 0;
        while (n2 < n) {
            MatchFilter matchFilter = matchFilterArray[n2];
            buf.append(matchFilter.getID());
            buf.append(';');
            ++n2;
        }
        return buf.toString();
    }

    private static MatchFilter[] decodeFiltersString(String encodedString) {
        StringTokenizer tokenizer = new StringTokenizer(encodedString, String.valueOf(';'));
        HashSet<MatchFilter> result = new HashSet<MatchFilter>();
        while (tokenizer.hasMoreTokens()) {
            MatchFilter curr = FileSearchResult.findMatchFilter(tokenizer.nextToken());
            if (curr == null) continue;
            result.add(curr);
        }
        return result.toArray(new MatchFilter[result.size()]);
    }

    private static MatchFilter findMatchFilter(String id) {
        MatchFilter[] matchFilterArray = ALL_MATCH_FILTERS;
        int n = ALL_MATCH_FILTERS.length;
        int n2 = 0;
        while (n2 < n) {
            MatchFilter matchFilter = matchFilterArray[n2];
            if (matchFilter.getID().equals(id)) {
                return matchFilter;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.getMatches(file);
    }

    @Override
    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    @Override
    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return match.getElement().equals(fi.getFile());
        }
        return false;
    }

    @Override
    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return this.getMatches(fi.getFile());
        }
        return this.EMPTY_ARR;
    }

    @Override
    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    @Override
    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    @Override
    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

