/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.signing;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.signing.ExternalProcessRunner;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

class ExternalGpg {
    private static final Map<String, String> EXECUTABLES = new ConcurrentHashMap<String, String>();

    ExternalGpg() {
    }

    static String getGpg() {
        return ExternalGpg.get("gpg");
    }

    static String getGpgSm() {
        return ExternalGpg.get("gpgsm");
    }

    static String findExecutable(String program) {
        try {
            String resolved;
            Path exe = Paths.get(program, new String[0]);
            if (!exe.isAbsolute() && exe.getNameCount() == 1 && (resolved = ExternalGpg.get(program)) != null) {
                return resolved;
            }
        }
        catch (InvalidPathException e) {
            Activator.logWarning(MessageFormat.format(CoreText.ExternalGpg_invalidPath, program), e);
        }
        return program;
    }

    private static String get(String program) {
        String resolved = EXECUTABLES.computeIfAbsent(program, ExternalGpg::findProgram);
        return resolved.isEmpty() ? null : resolved;
    }

    private static String findProgram(String program) {
        String bash;
        SystemReader system = SystemReader.getInstance();
        String path = system.getenv("PATH");
        String exe = null;
        if (system.isMacOS() && (bash = ExternalGpg.searchPath(path, "bash")) != null) {
            ProcessBuilder process = new ProcessBuilder(new String[0]);
            process.command(bash, "--login", "-c", "which " + program);
            process.directory(FS.DETECTED.userHome());
            String[] result = new String[1];
            try {
                ExternalProcessRunner.run(process, null, b -> {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (BufferedReader r = new BufferedReader(new InputStreamReader(b.openInputStream(), system.getDefaultCharset()));){
                        stringArray[0] = r.readLine();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }, null);
            }
            catch (IOException | CanceledException e) {
                Activator.logWarning(CoreText.ExternalGpgSigner_cannotSearch, e);
            }
            exe = result[0];
        }
        if (exe == null) {
            exe = ExternalGpg.searchPath(path, system.isWindows() ? ExternalGpg.completeWindowsPath(program) : program);
        }
        return exe == null ? "" : exe;
    }

    private static String completeWindowsPath(String program) {
        String name = new File(program).getName();
        if (name.equals(program) && name.indexOf(46) < 0) {
            return program + ".exe";
        }
        return program;
    }

    private static String searchPath(String path, String name) {
        if (StringUtils.isEmptyOrNull((String)path)) {
            return null;
        }
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            File exe = new File(p, name);
            try {
                if (exe.isFile() && exe.canExecute()) {
                    return exe.getAbsolutePath();
                }
            }
            catch (SecurityException e) {
                Activator.logWarning(MessageFormat.format(CoreText.ExternalGpgSigner_skipNotAccessiblePath, exe.getPath()), e);
            }
            ++n2;
        }
        return null;
    }
}

