/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.DLTKUIStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ImportRewrite;
import org.eclipse.php.internal.ui.text.correction.proposals.CUCorrectionProposal;
import org.eclipse.php.internal.ui.text.correction.proposals.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEdit;

public class ASTRewriteCorrectionProposal
extends CUCorrectionProposal {
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;

    public ASTRewriteCorrectionProposal(String name, ISourceModule cu, ASTRewrite rewrite, int relevance, Image image) {
        super(name, cu, relevance, image);
        this.fRewrite = rewrite;
    }

    public ImportRewrite getImportRewrite() {
        return this.fImportRewrite;
    }

    public void setImportRewrite(ImportRewrite rewrite) {
        this.fImportRewrite = rewrite;
    }

    public ImportRewrite createImportRewrite(Program astRoot) {
        this.fImportRewrite = ImportRewrite.create((Program)astRoot, (boolean)true);
        return this.fImportRewrite;
    }

    @Override
    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        super.addEdits(document, editRoot);
        ASTRewrite rewrite = this.getRewrite();
        if (rewrite != null) {
            try {
                TextEdit edit = rewrite.rewriteAST(document, null);
                editRoot.addChild(edit);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(DLTKUIStatus.createError((int)4, (Throwable)e));
            }
        }
        if (this.fImportRewrite != null) {
            editRoot.addChild(this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fRewrite == null) {
            IStatus status = DLTKUIStatus.createError((int)4, (String)Messages.ASTRewriteCorrectionProposal_0, null);
            throw new CoreException(status);
        }
        return this.fRewrite;
    }
}

