/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class LinkedNodeFinder {
    private LinkedNodeFinder() {
    }

    public static Identifier[] findByBinding(ASTNode root, IBinding binding) {
        ArrayList<Identifier> res = new ArrayList<Identifier>();
        BindingFinder nodeFinder = new BindingFinder(binding, res);
        root.accept((Visitor)nodeFinder);
        return res.toArray(new Identifier[res.size()]);
    }

    public static Identifier[] findByNode(ASTNode root, Identifier name) {
        IBinding binding = name.resolveBinding();
        if (binding != null) {
            return LinkedNodeFinder.findByBinding(root, binding);
        }
        return new Identifier[]{name};
    }

    private static class BindingFinder
    extends AbstractVisitor {
        private IModelElement fBinding;
        private List<Identifier> fResult;

        public BindingFinder(IBinding binding, List<Identifier> result) {
            this.fBinding = BindingFinder.getDeclaration(binding);
            this.fResult = result;
        }

        public boolean visit(Identifier node) {
            IBinding binding = node.resolveBinding();
            if (binding == null || this.fBinding == null) {
                return false;
            }
            if (this.fBinding.equals(binding.getPHPElement())) {
                this.fResult.add(node);
            }
            return false;
        }

        private static IModelElement getDeclaration(IBinding binding) {
            return binding.getPHPElement();
        }
    }
}

