/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodelimpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;
import org.eclipse.wst.css.core.internal.metamodel.CSSMetaModel;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSProfileImpl;

class CSSProfileTest {
    CSSProfileTest() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        CSSMetaModel metamodel = null;
        try {
            CSSProfileImpl profile = new CSSProfileImpl("test", new URL(args[0]));
            metamodel = profile.getMetaModel();
        }
        catch (MalformedURLException e) {
            Logger.logException(e);
        }
        if (metamodel == null) {
            return;
        }
        CSSProfileTest.debugOut(metamodel, 0, true);
    }

    static void debugOut(CSSMMNode node, int depth, boolean recursive) {
        String type = node.getType();
        int i = 0;
        while (i < depth) {
            System.out.print("\t");
            ++i;
        }
        System.out.print("[ " + node.getName() + "(" + type + ") ]");
        if (type == "CSSMM.Unit" || type == "CSSMM.Keyword" || type == "CSSMM.Function" || type == "CSSMM.Selector") {
            System.out.print(" -> " + node.toString());
        }
        System.out.println();
        if (recursive) {
            Iterator iNode = node.getChildNodes();
            while (iNode.hasNext()) {
                CSSProfileTest.debugOut((CSSMMNode)iNode.next(), depth + 1, true);
            }
        }
    }
}

