/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.structuremergeviewer.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.AbstractDifferenceFilter;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.tree.TreeNode;

public class GMFRefinedElementsFilter
extends AbstractDifferenceFilter {
    private static final Predicate<? super EObject> PREDICATE_WHEN_SELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            EObject data;
            if (input instanceof TreeNode && (data = ((TreeNode)input).getData()) instanceof Diff) {
                Diff diff = (Diff)data;
                return Iterables.any((Iterable)diff.getRefines(), (Predicate)Predicates.instanceOf(DiagramDiff.class));
            }
            return false;
        }
    };
    private static final Predicate<? super EObject> PREDICATE_WHEN_UNSELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            EPackage p;
            EObject data;
            if (input instanceof TreeNode && (data = ((TreeNode)input).getData()) != null && (p = data.eClass().getEPackage()) != null) {
                return p.getNsURI().startsWith("http://www.eclipse.org/emf/compare/diagram");
            }
            return false;
        }
    };

    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        if (scope != null) {
            for (String nsURI : scope.getNsURIs()) {
                if (!nsURI.matches("http://www\\.eclipse\\.org/gmf/runtime/.*/notation")) continue;
                return true;
            }
        }
        return false;
    }

    public Predicate<? super EObject> getPredicateWhenSelected() {
        return PREDICATE_WHEN_SELECTED;
    }

    public Predicate<? super EObject> getPredicateWhenUnselected() {
        return Predicates.alwaysFalse();
    }
}

