/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.creation;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.EditingSessionEvent;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateRepresentationAction
extends Action {
    private Session session;
    private EObject selection;
    private RepresentationDescription description;
    private DRepresentation createdDRepresentation;
    private ILabelProvider labelProvider;
    private String name;

    public CreateRepresentationAction(Session session, EObject selection, RepresentationDescription representationDescription, ILabelProvider labelProvider) {
        this.session = session;
        this.selection = selection;
        this.description = representationDescription;
        this.labelProvider = labelProvider;
        this.updateActionLabels();
    }

    void updateActionLabels() {
        Collection containers;
        ImageDescriptor descriptor = ImageDescriptor.getMissingImageDescriptor();
        Image descImage = this.labelProvider.getImage((Object)this.description);
        if (descImage != null) {
            descriptor = ImageDescriptor.createFromImage((Image)descImage);
        }
        this.setImageDescriptor(descriptor);
        this.computeRepresentationName();
        this.setText(this.name);
        this.setToolTipText(this.description.getEndUserDocumentation());
        if (this.session instanceof DAnalysisSessionImpl && !(containers = ((DAnalysisSessionImpl)this.session).getAvailableRepresentationContainers(this.description)).isEmpty()) {
            boolean enabled = false;
            for (DView container : containers) {
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)container);
                if (permissionAuthority != null && !permissionAuthority.canCreateIn((EObject)container)) continue;
                enabled = true;
                break;
            }
            this.setEnabled(enabled);
        }
    }

    public void run() {
        super.run();
        try {
            final String representationName = this.getRepresentationName();
            if (representationName == null) {
                return;
            }
            IRunnableWithProgress representationCreationRunnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.CreateRepresentationAction_creationTask, 5);
                        CreateRepresentationCommand createRepresentationCommand = new CreateRepresentationCommand(CreateRepresentationAction.this.session, CreateRepresentationAction.this.description, CreateRepresentationAction.this.selection, representationName, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                        IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(CreateRepresentationAction.this.session);
                        editingSession.notify(EditingSessionEvent.REPRESENTATION_ABOUT_TO_BE_CREATED_BEFORE_OPENING);
                        CreateRepresentationAction.this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)createRepresentationCommand);
                        editingSession.notify(EditingSessionEvent.REPRESENTATION_CREATED_BEFORE_OPENING);
                        CreateRepresentationAction.this.createdDRepresentation = createRepresentationCommand.getCreatedRepresentation();
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, representationCreationRunnable);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(Messages.CreateRepresentationAction_openingTask, 1);
                        DialectUIManager.INSTANCE.openEditor(CreateRepresentationAction.this.session, CreateRepresentationAction.this.createdDRepresentation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, null);
        }
        catch (InvocationTargetException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    protected String getRepresentationName() {
        Object descriptionLabel = null;
        if (this.description.getEndUserDocumentation() != null && this.description.getEndUserDocumentation().trim().length() > 0) {
            descriptionLabel = MessageFormat.format(org.eclipse.sirius.ui.tools.api.Messages.createRepresentationInputDialog_RepresentationDescriptionLabel, this.description.getEndUserDocumentation());
        }
        descriptionLabel = descriptionLabel == null ? "" : (String)descriptionLabel + "\n\n";
        descriptionLabel = (String)descriptionLabel + org.eclipse.sirius.ui.tools.api.Messages.createRepresentationInputDialog_NewRepresentationNameLabel;
        InputDialog askSiriusName = new InputDialog(Display.getDefault().getActiveShell(), MessageFormat.format(org.eclipse.sirius.ui.tools.api.Messages.createRepresentationInputDialog_Title, MessageTranslator.INSTANCE.getMessage((EObject)this.description, new IdentifiedElementQuery((IdentifiedElement)this.description).getLabel())), (String)descriptionLabel, this.name, new IInputValidator(){

            public String isValid(String newText) {
                return null;
            }
        });
        if (askSiriusName.open() == 0) {
            return askSiriusName.getValue();
        }
        return null;
    }

    private void computeRepresentationName() {
        IInterpreter interpreter = this.session.getInterpreter();
        this.name = org.eclipse.sirius.ui.tools.api.Messages.createRepresentationInputDialog_NamePrefix + MessageTranslator.INSTANCE.getMessage((EObject)this.description, new IdentifiedElementQuery((IdentifiedElement)this.description).getLabel());
        if (!StringUtil.isEmpty((String)this.description.getTitleExpression())) {
            try {
                this.name = interpreter.evaluateString(this.selection, this.description.getTitleExpression());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)this.description, (EStructuralFeature)DescriptionPackage.eINSTANCE.getRepresentationDescription_TitleExpression(), (Throwable)e);
            }
        }
    }
}

