/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class ExecutionEnvironmentSection
extends TableSection {
    private TableViewer fEETable;
    private Action fRemoveAction;
    private Action fAddAction;

    public ExecutionEnvironmentSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.RequiredExecutionEnvironmentSection_modify, PDEUIMessages.RequiredExecutionEnvironmentSection_add, PDEUIMessages.RequiredExecutionEnvironmentSection_remove});
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.RequiredExecutionEnvironmentSection_title);
        if (this.isFragment()) {
            section.setDescription(PDEUIMessages.RequiredExecutionEnvironmentSection_fragmentDesc);
        } else {
            section.setDescription(PDEUIMessages.RequiredExecutionEnvironmentSection_pluginDesc);
        }
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(this.isEditable());
        this.createViewerPartControl(container, 65538, 2, toolkit);
        this.fEETable = tablePart.getTableViewer();
        this.fEETable.setContentProvider((IContentProvider)((IStructuredContentProvider)inputElement -> {
            IBundleModel model;
            IBundle bundle;
            IManifestHeader header;
            if (inputElement instanceof IBundleModel && (header = (bundle = (model = (IBundleModel)inputElement).getBundle()).getManifestHeader("Bundle-RequiredExecutionEnvironment")) instanceof RequiredExecutionEnvironmentHeader) {
                RequiredExecutionEnvironmentHeader breeHeader = (RequiredExecutionEnvironmentHeader)header;
                return breeHeader.getElements();
            }
            return new Object[0];
        }));
        this.fEETable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        Hyperlink link = toolkit.createHyperlink(container, PDEUIMessages.BuildExecutionEnvironmentSection_configure, 0);
        link.addHyperlinkListener(IHyperlinkListener.linkActivatedAdapter(e -> {
            Shell shell = PDEPlugin.getActiveWorkbenchShell();
            SWTFactory.showPreferencePage(shell, "org.eclipse.jdt.debug.ui.jreProfiles", null);
        }));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        if (project != null && PluginProject.isJavaProject((IProject)project)) {
            link = toolkit.createHyperlink(container, PDEUIMessages.ExecutionEnvironmentSection_updateClasspath, 0);
            link.addHyperlinkListener(IHyperlinkListener.linkActivatedAdapter(e -> this.updateClasspathSettings(project)));
            gd = new GridData();
            gd.horizontalSpan = 2;
            link.setLayoutData((Object)gd);
        }
        this.makeActions();
        IBundleModel model = this.getBundleModel();
        if (model != null) {
            this.fEETable.setInput((Object)model);
            model.addModelChangedListener((IModelChangedListener)this);
            section.addDisposeListener(e -> model.removeModelChangedListener((IModelChangedListener)this));
        }
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    private void updateClasspathSettings(IProject project) {
        try {
            this.getPage().getEditor().doSave(null);
            IPluginModelBase model = PluginRegistry.findModel((IProject)project);
            if (model != null) {
                ClasspathComputer.setClasspath((IProject)project, (IPluginModelBase)model);
                if (PDEPlugin.getWorkspace().isAutoBuilding()) {
                    this.doFullBuild(project);
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void refresh() {
        this.fEETable.refresh();
        this.updateButtons();
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleModify();
                break;
            }
            case 1: {
                this.handleAdd();
                break;
            }
            case 2: {
                this.handleRemove();
            }
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fAddAction);
        if (!this.fEETable.getStructuredSelection().isEmpty()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void makeActions() {
        this.fAddAction = new Action(PDEUIMessages.RequiredExecutionEnvironmentSection_add){

            public void run() {
                ExecutionEnvironmentSection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(PDEUIMessages.NewManifestEditor_LibrarySection_remove){

            public void run() {
                ExecutionEnvironmentSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
    }

    private void updateButtons() {
        Table table = this.fEETable.getTable();
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable() && table.getItemCount() == 1);
        tablePart.setButtonEnabled(1, this.isEditable());
        tablePart.setButtonEnabled(2, this.isEditable() && table.getSelection().length > 0);
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fEETable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            for (Object object : ssel) {
                if (!(object instanceof ExecutionEnvironment)) continue;
                ExecutionEnvironment ee = (ExecutionEnvironment)object;
                this.getHeader().removeExecutionEnvironment(ee.getName());
            }
        }
    }

    private void handleAdd() {
        Object[] selection = this.showEESelectionDialog(true);
        if (selection != null) {
            this.addExecutionEnvironments(selection);
        }
    }

    private void handleModify() {
        RequiredExecutionEnvironmentHeader header = this.getHeader();
        Object[] selection = this.showEESelectionDialog(false);
        if (selection != null) {
            List existingEEs = header.getEnvironments();
            this.getHeader().removeExecutionEnvironment((String)existingEEs.get(0));
            this.addExecutionEnvironments(selection);
            IProject project = this.getPage().getPDEEditor().getCommonProject();
            this.updateClasspathSettings(project);
        }
    }

    private Object[] showEESelectionDialog(boolean allowMultiSelection) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new EELabelProvider()){

            protected FilteredList createFilteredList(Composite parent) {
                FilteredList filteredList = super.createFilteredList(parent);
                filteredList.setComparator(VMUtil.ASCENDING_EE_JAVA_VERSION.reversed());
                return filteredList;
            }
        };
        dialog.setElements((Object[])this.getEnvironments());
        dialog.setAllowDuplicates(false);
        dialog.setMultipleSelection(allowMultiSelection);
        dialog.setTitle(PDEUIMessages.RequiredExecutionEnvironmentSection_dialog_title);
        dialog.setMessage(PDEUIMessages.RequiredExecutionEnvironmentSection_dialogMessage);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.execution_environment_selection");
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    private void addExecutionEnvironments(Object[] result) {
        List<String> ees = Arrays.stream(result).map(resultObject -> {
            if (resultObject instanceof IExecutionEnvironment) {
                IExecutionEnvironment ee = (IExecutionEnvironment)resultObject;
                return ee.getId();
            }
            if (resultObject instanceof ExecutionEnvironment) {
                ExecutionEnvironment ee = (ExecutionEnvironment)resultObject;
                return ee.getName();
            }
            return null;
        }).filter(Objects::nonNull).toList();
        RequiredExecutionEnvironmentHeader header = this.getHeader();
        if (header == null) {
            String eeList = String.join((CharSequence)("," + this.getLineDelimiter() + " "), ees);
            this.getBundle().setHeader("Bundle-RequiredExecutionEnvironment", eeList);
        } else {
            RequiredExecutionEnvironmentHeader ee = header;
            ee.addExecutionEnvironments(ees);
        }
    }

    private String getLineDelimiter() {
        BundleInputContext inputContext = this.getBundleContext();
        if (inputContext != null) {
            return inputContext.getLineDelimiter();
        }
        return TextUtil.getDefaultLineDelimiter();
    }

    private IExecutionEnvironment[] getEnvironments() {
        RequiredExecutionEnvironmentHeader header = this.getHeader();
        IExecutionEnvironmentsManager eeManager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] envs = eeManager.getExecutionEnvironments();
        if (header == null) {
            return envs;
        }
        List<IExecutionEnvironment> ees = header.getElementNames().stream().map(arg_0 -> ((IExecutionEnvironmentsManager)eeManager).getEnvironment(arg_0)).toList();
        return (IExecutionEnvironment[])Arrays.stream(envs).filter(ee -> !ees.contains(ee)).toArray(IExecutionEnvironment[]::new);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        } else if (e.getChangeType() == 2) {
            Object[] objects;
            Object[] objectArray = objects = e.getChangedObjects();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Table table = this.fEETable.getTable();
                if (object instanceof ExecutionEnvironment) {
                    int index = table.getSelectionIndex();
                    this.fEETable.remove(object);
                    if (this.canSelect()) {
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                    }
                }
                ++n2;
            }
            this.updateButtons();
        } else if (e.getChangeType() == 1) {
            Object[] objects = e.getChangedObjects();
            if (objects.length > 0) {
                this.fEETable.refresh();
                this.fEETable.setSelection((ISelection)new StructuredSelection(objects[objects.length - 1]));
            }
            this.updateButtons();
        } else if ("Bundle-RequiredExecutionEnvironment".equals(e.getChangedProperty())) {
            this.refresh();
            Object lastElement = this.fEETable.getElementAt(this.fEETable.getTable().getItemCount() - 1);
            if (lastElement != null) {
                this.fEETable.setSelection((ISelection)new StructuredSelection(lastElement));
            }
        }
    }

    private BundleInputContext getBundleContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (BundleInputContext)manager.findContext("bundle-context");
    }

    private IBundle getBundle() {
        IBundleModel model = this.getBundleModel();
        return model == null ? null : model.getBundle();
    }

    private IBundleModel getBundleModel() {
        BundleInputContext context = this.getBundleContext();
        return context == null ? null : context.getModel();
    }

    protected RequiredExecutionEnvironmentHeader getHeader() {
        RequiredExecutionEnvironmentHeader breeHeader;
        IBundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        IManifestHeader header = bundle.getManifestHeader("Bundle-RequiredExecutionEnvironment");
        return header instanceof RequiredExecutionEnvironmentHeader ? (breeHeader = (RequiredExecutionEnvironmentHeader)header) : null;
    }

    protected boolean isFragment() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        IBaseModel iBaseModel = manager.getAggregateModel();
        if (iBaseModel instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)iBaseModel;
            return model.isFragmentModel();
        }
        return false;
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        RequiredExecutionEnvironmentHeader header = this.getHeader();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ExecutionEnvironment) {
                ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)object;
                String env = executionEnvironment.getName();
                if (header == null || !header.hasElement(env)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        if (this.getPage().getModel().isEditable()) {
            this.updateButtons();
        }
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        this.addExecutionEnvironments(objects);
    }

    private void doFullBuild(final IProject project) {
        Job buildJob = new Job(PDEUIMessages.CompilersConfigurationBlock_building){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    project.build(6, "org.eclipse.jdt.core.javabuilder", null, monitor);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.schedule();
    }

    private static class EELabelProvider
    extends LabelProvider {
        private final Image fImage = PDEPluginImages.DESC_JAVA_LIB_OBJ.createImage();

        public Image getImage(Object element) {
            return this.fImage;
        }

        public String getText(Object element) {
            if (element instanceof IExecutionEnvironment) {
                return ((IExecutionEnvironment)element).getId();
            }
            return super.getText(element);
        }

        public void dispose() {
            if (this.fImage != null) {
                this.fImage.dispose();
            }
            super.dispose();
        }
    }
}

