/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.tools;

import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IRotatableEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.requests.RotateShapeRequest;
import org.eclipse.swt.graphics.Cursor;

public class RotateTracker
extends ResizeTracker {
    private int direction;

    public RotateTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
        this.direction = direction;
    }

    private boolean isRotationRequired() {
        boolean result = true;
        int i = 0;
        while (i < this.getOperationSet().size() && result) {
            result = this.getOperationSet().get(i) instanceof IRotatableEditPart ? ((IRotatableEditPart)this.getOperationSet().get(i)).isRotatable() : false;
            ++i;
        }
        return result;
    }

    protected void updateSourceRequest() {
        super.updateSourceRequest();
        RotateShapeRequest request = (RotateShapeRequest)this.getSourceRequest();
        request.setRotate(this.isRotationRequired());
    }

    protected Request createSourceRequest() {
        RotateShapeRequest request = new RotateShapeRequest((Object)"resize");
        request.setResizeDirection(this.getResizeDirection());
        return request;
    }

    protected Cursor getDefaultCursor() {
        return this.isRotationRequired() ? Cursors.HAND : Cursors.getDirectionalCursor((int)this.direction);
    }
}

