/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.codan.core.cxx.Activator;
import org.eclipse.cdt.codan.core.cxx.model.CxxModelsCache;
import org.eclipse.cdt.codan.core.cxx.model.ICAstChecker;
import org.eclipse.cdt.codan.core.cxx.model.ICodanCommentMap;
import org.eclipse.cdt.codan.core.model.AbstractCheckerWithProblemPreferences;
import org.eclipse.cdt.codan.core.model.ICheckerInvocationContext;
import org.eclipse.cdt.codan.core.model.ICodanDisposable;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemLocationFactory;
import org.eclipse.cdt.codan.core.model.IRunnableInEditorChecker;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class AbstractIndexAstChecker
extends AbstractCheckerWithProblemPreferences
implements ICAstChecker,
IRunnableInEditorChecker {
    private CxxModelsCache modelCache;

    public synchronized boolean processResource(IResource resource) throws OperationCanceledException {
        if (!this.shouldProduceProblems(resource)) {
            return false;
        }
        if (!(resource instanceof IFile)) {
            return true;
        }
        this.processFile((IFile)resource);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(IFile file) throws OperationCanceledException {
        block13: {
            ICheckerInvocationContext context;
            ICheckerInvocationContext iCheckerInvocationContext = context = this.getContext();
            synchronized (iCheckerInvocationContext) {
                this.modelCache = (CxxModelsCache)context.get(CxxModelsCache.class);
                if (this.modelCache == null) {
                    ICElement celement = CoreModel.getDefault().create(file);
                    if (!(celement instanceof ITranslationUnit)) {
                        return;
                    }
                    this.modelCache = new CxxModelsCache((ITranslationUnit)celement);
                    context.add((ICodanDisposable)this.modelCache);
                }
            }
            try {
                try {
                    IASTTranslationUnit ast;
                    if (!this.modelCache.getIndex().isFullyInitialized() || (ast = this.modelCache.getAST()) == null) break block13;
                    IASTTranslationUnit iASTTranslationUnit = ast;
                    synchronized (iASTTranslationUnit) {
                        this.processAst(ast);
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                    this.modelCache = null;
                }
            }
            finally {
                this.modelCache = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processModel(Object model, ICheckerInvocationContext context) {
        if (model instanceof IASTTranslationUnit) {
            IASTTranslationUnit ast = (IASTTranslationUnit)model;
            if (ast.isBasedOnIncompleteIndex()) {
                return;
            }
            this.setContext(context);
            ICheckerInvocationContext iCheckerInvocationContext = context;
            synchronized (iCheckerInvocationContext) {
                this.modelCache = (CxxModelsCache)context.get(CxxModelsCache.class);
                if (this.modelCache == null) {
                    this.modelCache = new CxxModelsCache(ast);
                    context.add((ICodanDisposable)this.modelCache);
                }
            }
            CPPSemantics.pushLookupPoint((IASTNode)ast);
            try {
                this.processAst(ast);
            }
            finally {
                this.modelCache = null;
                this.setContext(null);
                CPPSemantics.popLookupPoint();
            }
        }
    }

    public boolean runInEditor() {
        return true;
    }

    public void reportProblem(String id, IASTNode astNode, Object ... args) {
        IProblemLocation loc = this.getProblemLocation(astNode);
        if (loc != null) {
            this.reportProblem(id, loc, args);
        }
    }

    public void reportProblem(IProblem problem, IASTNode astNode, Object ... args) {
        IProblemLocation loc = this.getProblemLocation(astNode);
        if (loc != null) {
            this.reportProblem(problem, loc, args);
        }
    }

    protected boolean shouldProduceProblem(IProblem problem, IProblemLocation loc, Object ... args) {
        String suppressionComment = (String)this.getSuppressionCommentPreference(problem).getValue();
        if (suppressionComment.isEmpty()) {
            return super.shouldProduceProblem(problem, loc, args);
        }
        List<IASTComment> lineComments = this.getLineCommentsForLocation(loc);
        for (IASTComment astComment : lineComments) {
            if (!astComment.getRawSignature().contains(suppressionComment)) continue;
            return false;
        }
        return super.shouldProduceProblem(problem, loc, args);
    }

    protected List<IASTComment> getLineCommentsForLocation(IProblemLocation loc) {
        ArrayList<IASTComment> lineComments = new ArrayList<IASTComment>();
        try {
            IASTComment[] commentsArray;
            IASTComment[] iASTCommentArray = commentsArray = this.modelCache.getAST().getComments();
            int n = commentsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String commentFile;
                String problemFile;
                IASTComment comm = iASTCommentArray[n2];
                IASTFileLocation fileLocation = comm.getFileLocation();
                if (fileLocation.getStartingLineNumber() == loc.getLineNumber() && (problemFile = loc.getFile().getLocation().toOSString()).equals(commentFile = fileLocation.getFileName())) {
                    lineComments.add(comm);
                }
                ++n2;
            }
        }
        catch (CoreException | OperationCanceledException e) {
            Activator.log(e);
        }
        return lineComments;
    }

    protected IProblemLocation getProblemLocation(IASTNode astNode) {
        IASTFileLocation astLocation = astNode.getFileLocation();
        return this.getProblemLocation(astNode, astLocation);
    }

    private IProblemLocation getProblemLocation(IASTNode astNode, IASTFileLocation astLocation) {
        IASTImageLocation imageLocation;
        int line = astLocation.getStartingLineNumber();
        IProblemLocationFactory locFactory = this.getRuntime().getProblemLocationFactory();
        if (AbstractIndexAstChecker.enclosedInMacroExpansion(astNode) && astNode instanceof IASTName && (imageLocation = ((IASTName)astNode).getImageLocation()) != null) {
            int start = imageLocation.getNodeOffset();
            int end = start + imageLocation.getNodeLength();
            return locFactory.createProblemLocation(this.getFile(), start, end, line);
        }
        if (astNode instanceof IASTCompositeTypeSpecifier) {
            return locFactory.createProblemLocation(this.getFile(), line);
        }
        int start = astLocation.getNodeOffset();
        int end = start + astLocation.getNodeLength();
        return locFactory.createProblemLocation(this.getFile(), start, end, line);
    }

    protected static boolean enclosedInMacroExpansion(IASTNode node) {
        IASTNodeLocation[] nodeLocations = node.getNodeLocations();
        return nodeLocations.length == 1 && nodeLocations[0] instanceof IASTMacroExpansionLocation;
    }

    protected static boolean includesMacroExpansion(IASTNode node) {
        IASTNodeLocation[] iASTNodeLocationArray = node.getNodeLocations();
        int n = iASTNodeLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNodeLocation nodeLocation = iASTNodeLocationArray[n2];
            if (nodeLocation instanceof IASTMacroExpansionLocation) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IFile getFile() {
        return this.modelCache.getFile();
    }

    protected IProject getProject() {
        IFile file = this.getFile();
        return file == null ? null : file.getProject();
    }

    protected CxxModelsCache getModelCache() {
        return this.modelCache;
    }

    protected ICodanCommentMap getCommentMap() {
        return this.modelCache.getCommentedNodeMap();
    }
}

