/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.filewizard;

import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.internal.ui.wizards.filewizard.AbstractFileCreationWizardPage;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewFileWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewSourceFileGenerator;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewSourceFileCreationWizardPage
extends AbstractFileCreationWizardPage {
    private final String KEY_LAST_USED_TEMPLATE = "LastUsedSourceTemplate";
    private ITranslationUnit fNewFileTU = null;
    private StringDialogField fNewFileDialogField;

    public NewSourceFileCreationWizardPage() {
        super(NewFileWizardMessages.NewSourceFileCreationWizard_title);
        this.setTitle(NewFileWizardMessages.NewSourceFileCreationWizardPage_title);
        this.setDescription(NewFileWizardMessages.NewSourceFileCreationWizardPage_description);
        this.fNewFileDialogField = new StringDialogField();
        this.fNewFileDialogField.setDialogFieldListener(new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                NewSourceFileCreationWizardPage.this.handleFieldChanged(2);
            }
        });
        this.fNewFileDialogField.setLabelText(NewFileWizardMessages.NewSourceFileCreationWizardPage_sourceFile_label);
    }

    @Override
    protected void setFocus() {
        this.fNewFileDialogField.setFocus();
    }

    @Override
    protected void createFileControls(Composite parent, int nColumns) {
        this.fNewFileDialogField.doFillIntoGrid(parent, nColumns);
        Text textControl = this.fNewFileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new AbstractFileCreationWizardPage.StatusFocusListener(2));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getParent(), "org.eclipse.cdt.ui.cdt_creating_cpp_file_context");
    }

    @Override
    public IPath getFileFullPath() {
        IPath folderPath;
        String str = this.fNewFileDialogField.getText();
        Path path = null;
        if (str.length() > 0 && !(path = new Path(str)).isAbsolute() && (folderPath = this.getSourceFolderFullPath()) != null) {
            path = folderPath.append((IPath)path);
        }
        return path;
    }

    @Override
    protected IStatus fileNameChanged() {
        StatusInfo status = new StatusInfo();
        IPath filePath = this.getFileFullPath();
        if (filePath == null) {
            status.setError(NewFileWizardMessages.NewSourceFileCreationWizardPage_error_EnterFileName);
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(filePath)) {
            status.setError(NewFileWizardMessages.NewSourceFileCreationWizardPage_error_FileNotInSourceFolder);
            return status;
        }
        IResource file = this.getWorkspaceRoot().findMember(filePath);
        if (file != null && file.exists()) {
            if (file.getType() == 1) {
                status.setError(NewFileWizardMessages.NewSourceFileCreationWizardPage_error_FileExists);
            } else if (file.getType() == 2) {
                status.setError(NewFileWizardMessages.NewSourceFileCreationWizardPage_error_MatchingFolderExists);
            } else {
                status.setError(NewFileWizardMessages.NewSourceFileCreationWizardPage_error_MatchingResourceExists);
            }
            return status;
        }
        IPath folderPath = filePath.removeLastSegments(1).makeRelative();
        IResource folder = this.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NLS.bind((String)NewFileWizardMessages.NewSourceFileCreationWizardPage_error_FolderDoesNotExist, (Object)folderPath));
            return status;
        }
        IStatus convStatus = CConventions.validateSourceFileName((IProject)this.getCurrentProject(), (String)filePath.lastSegment());
        if (convStatus.getSeverity() == 4) {
            status.setError(NLS.bind((String)NewFileWizardMessages.NewSourceFileCreationWizardPage_error_InvalidFileName, (Object)convStatus.getMessage()));
            return status;
        }
        if (convStatus.getSeverity() == 2) {
            status.setWarning(NLS.bind((String)NewFileWizardMessages.NewSourceFileCreationWizardPage_warning_FileNameDiscouraged, (Object)convStatus.getMessage()));
        }
        return status;
    }

    @Override
    public void createFile(IProgressMonitor monitor) throws CoreException {
        IPath filePath = this.getFileFullPath();
        if (filePath != null) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                this.fNewFileTU = null;
                IFile newFile = NewSourceFileGenerator.createSourceFile(filePath, true, monitor);
                if (newFile != null) {
                    this.fNewFileTU = (ITranslationUnit)CoreModel.getDefault().create(newFile);
                    if (this.fNewFileTU != null) {
                        String lineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)this.fNewFileTU);
                        String content = CodeGeneration.getBodyFileContent(this.getTemplate(), this.fNewFileTU, null, null, lineDelimiter);
                        if (content != null) {
                            this.fNewFileTU.getBuffer().setContents(content.toCharArray());
                            this.fNewFileTU.save(monitor, true);
                        }
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    @Override
    public ITranslationUnit getCreatedFileTU() {
        return this.fNewFileTU;
    }

    @Override
    protected Template[] getApplicableTemplates() {
        return StubUtility.getFileTemplatesForContentTypes(new String[]{"org.eclipse.cdt.core.cxxSource", "org.eclipse.cdt.core.cSource"}, null);
    }

    @Override
    public String getDefaultTemplateName() {
        String contentType;
        Template[] templates;
        IProject project;
        String name = this.getDialogSettings().get("LastUsedSourceTemplate");
        if (name == null && (project = this.getCurrentProject()) != null && (templates = StubUtility.getFileTemplatesForContentTypes(new String[]{contentType = CProject.hasCCNature((IProject)project) ? "org.eclipse.cdt.core.cxxSource" : "org.eclipse.cdt.core.cSource"}, null)).length != 0) {
            name = templates[0].getName();
        }
        return name;
    }

    @Override
    public void saveLastUsedTemplateName(String name) {
        this.getDialogSettings().put("LastUsedSourceTemplate", name);
    }
}

