/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.commands;

import java.net.URL;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.IChangeReverseMethodHandler;
import org.eclipse.cdt.debug.core.model.IReverseToggleHandler;
import org.eclipse.cdt.debug.internal.ui.commands.Messages;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.DebugCommandHandler;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.services.IEvaluationService;
import org.osgi.framework.Bundle;

public class ReverseToggleCommandHandler
extends DebugCommandHandler
implements IDebugContextListener,
IElementUpdater {
    private static final ImageDescriptor REVERSE_TOGGLE_DEFAULT_IMAGE = ReverseToggleCommandHandler.getImageDescriptor("icons/obj16/reverse_toggle.gif");
    private static final ImageDescriptor REVERSE_TOGGLE_SOFTWARE_ON_IMAGE = ReverseToggleCommandHandler.getImageDescriptor("icons/obj16/reverse_toggle_sw_on.png");
    private static final ImageDescriptor REVERSE_TOGGLE_SOFTWARE_OFF_IMAGE = ReverseToggleCommandHandler.getImageDescriptor("icons/obj16/reverse_toggle_sw_off.png");
    private static final ImageDescriptor REVERSE_TOGGLE_HARDWARE_ON_IMAGE = ReverseToggleCommandHandler.getImageDescriptor("icons/obj16/reverse_toggle_hw_on.png");
    private static final ImageDescriptor REVERSE_TOGGLE_HARDWARE_OFF_IMAGE = ReverseToggleCommandHandler.getImageDescriptor("icons/obj16/reverse_toggle_hw_off.png");
    private static final String REVERSE_TOGGLE_COMMAND_ID = "org.eclipse.cdt.debug.ui.command.reverseToggle";
    private Object fActiveContext;
    private IReverseToggleHandler fTargetAdapter;
    private IDebugContextService fContextService;

    protected Class<?> getCommandType() {
        return IReverseToggleHandler.class;
    }

    private static ImageDescriptor getImageDescriptor(String path) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.cdt.debug.ui");
        URL url = null;
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)) != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }

    public ReverseToggleCommandHandler() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.fContextService = DebugUITools.getDebugContextManager().getContextService(window);
            if (this.fContextService != null) {
                this.fContextService.addPostDebugContextListener((IDebugContextListener)this);
                this.refresh(this.fContextService.getActiveContext());
            }
        }
    }

    public void dispose() {
        if (this.fContextService != null) {
            this.fContextService.removePostDebugContextListener((IDebugContextListener)this);
        }
        this.fTargetAdapter = null;
        this.fActiveContext = null;
        super.dispose();
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.refresh(event.getContext());
    }

    private void refresh(ISelection selection) {
        ICommandService commandService;
        IStructuredSelection ss;
        this.fTargetAdapter = null;
        this.fActiveContext = null;
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            this.fActiveContext = ss.getFirstElement();
            if (this.fActiveContext instanceof IAdaptable) {
                this.fTargetAdapter = this.getAdapter((IAdaptable)this.fActiveContext);
            }
        }
        if ((commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)) != null) {
            commandService.refreshElements(REVERSE_TOGGLE_COMMAND_ID, null);
        }
    }

    private IReverseToggleHandler getAdapter(IAdaptable adaptable) {
        IAdapterManager adapterManager;
        IReverseToggleHandler adapter = (IReverseToggleHandler)adaptable.getAdapter(IReverseToggleHandler.class);
        if (adapter == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)adaptable, this.getCommandType().getName())) {
            adapter = (IReverseToggleHandler)adapterManager.loadAdapter((Object)adaptable, IReverseToggleHandler.class.getName());
        }
        if (adapter instanceof IChangeReverseMethodHandler) {
            return adapter;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IChangeReverseMethodHandler.ReverseDebugMethod newMethod;
            if (HandlerUtil.matchesRadioState((ExecutionEvent)event)) {
                return null;
            }
            String radioState = event.getParameter("org.eclipse.ui.commands.radioStateParameter");
            if (radioState.equals("UseSoftTrace")) {
                newMethod = IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE;
            } else if (radioState.equals("TraceOff")) {
                newMethod = IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
            } else {
                if (!radioState.equals("UseHardTrace")) {
                    throw new ExecutionException(Messages.ReverseDebugging_UndefinedTraceMethod);
                }
                newMethod = IChangeReverseMethodHandler.ReverseDebugMethod.HARDWARE;
            }
            if (this.fTargetAdapter != null && this.fTargetAdapter instanceof IChangeReverseMethodHandler) {
                IChangeReverseMethodHandler.ReverseDebugMethod currMethod = ((IChangeReverseMethodHandler)this.fTargetAdapter).getReverseDebugMethod(this.fActiveContext);
                if (currMethod == newMethod) {
                    return null;
                }
                ((IChangeReverseMethodHandler)this.fTargetAdapter).setReverseDebugMethod(newMethod);
            }
            super.execute(event);
            HandlerUtil.updateRadioState((Command)event.getCommand(), (String)radioState);
            return null;
        }
        catch (NullPointerException | ExecutionException e) {
            if (this.fTargetAdapter != null && this.fTargetAdapter instanceof IChangeReverseMethodHandler && this.fTargetAdapter.toggleNeedsUpdating()) {
                IChangeReverseMethodHandler.ReverseDebugMethod prevMethod;
                IChangeReverseMethodHandler.ReverseDebugMethod currMethod = ((IChangeReverseMethodHandler)this.fTargetAdapter).getReverseDebugMethod(this.fActiveContext);
                IChangeReverseMethodHandler.ReverseDebugMethod newMethod = currMethod == IChangeReverseMethodHandler.ReverseDebugMethod.OFF ? ((prevMethod = ((IChangeReverseMethodHandler)this.fTargetAdapter).getPreviousReverseDebugMethod(this.fActiveContext)) == IChangeReverseMethodHandler.ReverseDebugMethod.HARDWARE ? IChangeReverseMethodHandler.ReverseDebugMethod.HARDWARE : IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE) : IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
                ((IChangeReverseMethodHandler)this.fTargetAdapter).setReverseDebugMethod(newMethod);
            }
            super.execute(event);
            return null;
        }
    }

    protected void postExecute(final IRequest request, Object[] targets) {
        super.postExecute(request, targets);
        new WorkbenchJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ICommandService commandService;
                IEvaluationService exprService;
                if (request.getStatus() != null && request.getStatus().getCode() != 0) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    Shell activeShell = null;
                    activeShell = window != null ? window.getShell() : new Shell(PlatformUI.getWorkbench().getDisplay());
                    MessageDialog dialogbox = new MessageDialog(activeShell, Messages.ReverseDebugging_Error, null, request.getStatus().getMessage(), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dialogbox.open();
                }
                if ((exprService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class)) != null) {
                    exprService.requestEvaluation("org.eclipse.cdt.debug.ui.isReverseDebuggingEnabled");
                }
                if ((commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)) != null) {
                    commandService.refreshElements(ReverseToggleCommandHandler.REVERSE_TOGGLE_COMMAND_ID, null);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void updateElement(UIElement element, Map parameters) {
        if (this.fTargetAdapter != null && this.fTargetAdapter instanceof IChangeReverseMethodHandler) {
            IChangeReverseMethodHandler.ReverseDebugMethod currMethod = ((IChangeReverseMethodHandler)this.fTargetAdapter).getReverseDebugMethod(this.fActiveContext);
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            try {
                if (currMethod == IChangeReverseMethodHandler.ReverseDebugMethod.HARDWARE) {
                    HandlerUtil.updateRadioState((Command)commandService.getCommand(REVERSE_TOGGLE_COMMAND_ID), (String)"UseHardTrace");
                    element.setTooltip(Messages.ReverseDebugging_ToggleHardwareTrace);
                    element.setIcon(REVERSE_TOGGLE_HARDWARE_ON_IMAGE);
                } else if (currMethod == IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE) {
                    HandlerUtil.updateRadioState((Command)commandService.getCommand(REVERSE_TOGGLE_COMMAND_ID), (String)"UseSoftTrace");
                    element.setTooltip(Messages.ReverseDebugging_ToggleSoftwareTrace);
                    element.setIcon(REVERSE_TOGGLE_SOFTWARE_ON_IMAGE);
                } else {
                    HandlerUtil.updateRadioState((Command)commandService.getCommand(REVERSE_TOGGLE_COMMAND_ID), (String)"TraceOff");
                    element.setTooltip(Messages.ReverseDebugging_ToggleReverseDebugging);
                    IChangeReverseMethodHandler.ReverseDebugMethod prevMethod = ((IChangeReverseMethodHandler)this.fTargetAdapter).getPreviousReverseDebugMethod(this.fActiveContext);
                    if (prevMethod == IChangeReverseMethodHandler.ReverseDebugMethod.HARDWARE) {
                        element.setIcon(REVERSE_TOGGLE_HARDWARE_OFF_IMAGE);
                    } else if (prevMethod == IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE) {
                        element.setIcon(REVERSE_TOGGLE_SOFTWARE_OFF_IMAGE);
                    } else {
                        element.setIcon(REVERSE_TOGGLE_DEFAULT_IMAGE);
                    }
                }
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }
}

